#include "alldf.h"
#include <stdlib.h>
#include <stdio.h>
#include "kpdatafile.h"
#include "dsdebug.h"

KAllDF::KAllDF (void)
{
  int i;

  n=prevn=0;
  dsdebug ("!\n");
  //  extraData = new int [AD_MAXDP];
  for (i=0;i<AD_MAXDP;i++)
    extraData [i]=0;
  dsdebug ("! %d\n",n);
	 
}

int KAllDF::search (char *filename, char *opts, int &type)
{
  //If filename and opts are matched then
  //  the index is returned and type is set to 1.
  //If filename is matched, but not opts, then
  //  the index is returned and type is set to 2.
  //Otherwise, -1 is returned.

  SOpts sopts;
  int i, maybe=-1;

  parseOpts (opts, &sopts);

  for (i=0;i<n;i++)
    {
      dsdebug ("== %d %d\n",i,n);
      dsdebug ("[%s] [%s]\n",entry[i]->qsfilename->data(),
	      entry[i]->qsopts->data());
      if (*(entry [i]->qsfilename) == filename)
	{
	  //compareOpts() checks to see if the options (as opposed to
	  // text in opts) are the same
	  if (compareOpts (sopts,i,0))
	    {
	      type=1;
	      return i;
	    }
	  else if(maybe==-1 && //match the first occurence
	  //if the opts are "equal enough" to allow us to use 
	  // the same data, then compareOpts() returns 1
		  compareOpts (sopts,i,1)) 
	    maybe=i; //don't return, b/c we'd prefer a type 1 match
	    
	}
    }

  type = 0;//(maybe!=-1 ? 2 : 0);

  return maybe;
}

int KAllDF::addDataSet (char *filename, char *opts)
{
  int e, stype;


  e=search (filename, opts, stype);
  dsdebug ("search [%d]\n",stype);

  if (stype==1) //already added
    return e;
    
  //will use opts to change this later
  if (n>AD_MAXDP)
    return alldferr_noMem;

  if (!QFile::exists (filename))
    return alldferr_noFile;

  if ((data[n]=new SDatapack)==0)
    return alldferr_noMem;

  if (stype!=1)  //allocate data for this only if we haven't already
                 //in another entry
    if ((data[n]->data=new SDElement [AD_MAXDE])==0)
    return alldferr_noMem;

  if ((entry [n]=new ADFEntry)==0)
    return alldferr_noMem;
  
  //later we might parse the opts right here
  //and have nicer opts.members of ADFEntry

  dsdebug ("opts=[%s]\n",opts);
  entry[n]->qsopts=new QString (opts);

  if (stype==1)
    {
      data [n]->loaded=data [e]->loaded;
      entry [n]->filebase=e;
      entry [n]->qsfilename=new QString ("");
    }
  else
    {
      entry[n]->qsfilename=new QString (filename);
      data [n]->loaded=FALSE;
      entry[n]->filebase=n;
    }
  
  data [n]->max=0;
  setExtra (n,0);


  parseOpts (entry [n]->qsopts->data(), &entry [n]->opts);

  n++;
  return n-1;
}

int KAllDF::compareOpts (SOpts &sopts, int i, int) //", int type)"
  //type 0:
  //Are the options exactly the same?
  //type 1:
  //Are the options in sopts and entry [i]->opts similar enough
  // so that we could use data [i] for this new dataset?
  //If so, return 1
{
  //no difference between types 0 and 1 right now

  if (sopts.xclm != entry [i]->opts.xclm)
    return 0;
  if (sopts.xclm != entry [i]->opts.xclm)
    return 0;

  return 1;
}

void KAllDF::optsDefaults (SOpts *opts)
{

  opts->xclm=0;
  opts->yclm=1;

}

void KAllDF::parseOpts (char *optstring, SOpts *opts)
{
  int j,oj=0;
  QString qs (optstring);
  
  dsdebug ("PARSE\n");
  optsDefaults (opts);
  qs.stripWhiteSpace();

  do
    {
      j=qs.find('=',oj);
      if (j==-1)
	return;
      QString opt (qs.mid (oj,j-oj));
      oj=j+1;

      j=qs.find (';',oj);
      if (j==-1)
	j=qs.length();

      QString val (qs.mid (oj,j-oj));
      oj=j+1;

      opt.lower();
      opt.stripWhiteSpace();
      val.lower();

      dsdebug ("parse: [%s] [%s]\n",opt.data(),val.data());

      //check the various options here
      if (opt=="x")
	opts->xclm=val.toInt()-1;
      else if (opt=="y")
	opts->yclm=val.toInt()-1;

    } while ((unsigned)j<qs.length());

}
    

double KAllDF::getx (int i, unsigned long  j)
{
  if (load (i))
    {
      if (j>=maxn (i))
	return data [entry [i]->filebase]->data [maxn(i)-1].x;
      return data [entry [i]->filebase]->data [j].x;
    }
  else 
    return 0;
}

double KAllDF::gety (int i, unsigned long  j)
{
  if (load (i))
    {
      if (j>=maxn (i))
	return 0;
      return data [entry [i]->filebase]->data [j].y;
    }
  else
    return 0;
}



bool KAllDF::load (int i)
{
  int iuse = entry [i]->filebase;

  if (data [iuse]->loaded)
    return TRUE;

  unsigned long j;
  double columns [AD_MAXCLMS];

  //  dsdebug ("i=%d iuse=%d  fn=[%s]\n",i,iuse,entry[iuse]->qsfilename->data());

  KPDataFile kdf (entry [iuse]->qsfilename->data());

  if (!kdf.isOk())
    return FALSE;

  j=0;
  int e;
  int xclm=entry[i]->opts.xclm;
  int yclm=entry[i]->opts.yclm;

  while ((e=kdf.read (columns, 100))>0)
    {
      if (xclm<e && yclm<e)
	{
	  data [iuse]->data[j].x=columns [xclm];
	  data [iuse]->data[j++].y=columns [yclm];
	  //dsdebug ("j=%ld  %f %f  %d\n",j,columns [xclm],columns [yclm],e);
	}
    }
  data [iuse]->max=j;
  data [iuse]->loaded=TRUE;

  return TRUE;
}   


void KAllDF::setExtra (int i, int _extra) 
{
  if (i<AD_MAXDP)
    extraData [i]=_extra;
}

int KAllDF::extra  (int i)
{
  if (i<n)
    return extraData [i];
  else
    return 0;
}

unsigned long KAllDF::maxn (int i)
{
  if (i<n)
    return data [entry [i]->filebase]->max;
  else
    return 0;
}
