#ifndef _KPLOTWIN_H
#define _KPLOTWIN_H

#include <qstack.h>
#include <qwidget.h>

#include "expression.h"
#include "kfunction.h"


void paintExpressions( QPaintDevice* pd );
void paintGrid( QPaintDevice* pd, QPainter* p, int h, float deltaX,
		float deltaY );


struct KViewport {
  double minX, minY, maxX, maxY;
}; // KViewport


class KPlotWindow;

class KPlotWindow : public QWidget
{
  Q_OBJECT

public:
  KPlotWindow( QWidget* parent );
 ~KPlotWindow();

public slots:
  void unzoom();

protected:
  double deltaX, deltaY;
  int h;

  /* used when drawing the selection */
  bool rectStart;
  QPainter* painter;
  int rectX1, rectY1, rectX2, rectY2;
  QStack<KViewport>* lastViewports;

  virtual void paintEvent( QPaintEvent* );
  virtual void resizeEvent( QResizeEvent* e );
  virtual void mouseMoveEvent( QMouseEvent* e );
  virtual void mousePressEvent( QMouseEvent* e );
  virtual void mouseReleaseEvent( QMouseEvent* e );

signals:
  void mouseAt( double x, double y );
}; // class KPlotWindow

#endif // _KPLOTWIN_H
