#ifndef _KPLOT_H
#define _KPLOT_H

#include <kapp.h>
#include <kstatusbar.h>
#include <ktopwidget.h>

#include "expression.h"
#include "kfunction.h"
#include "kfunctoolbar.h"
#include "kplotwin.h"

class KPlot;
class KPlotMainWindow;


class KPlot : public KApplication
{
  Q_OBJECT

public:
  KPlot( int& argc, char** argv );

public slots:
  void newExpression();
  void delExpression( uint index );
  void print();

signals:
  void expressionAdded();
  void expressionDeleted( uint index );
}; // class KPlot


class KPlotMainWindow : public KTopLevelWidget
{
  Q_OBJECT

public:
  KPlotMainWindow();

private:
  QPopupMenu* qpmOptions;
  KStatusBar* statusBar;
  KFunctionToolBar* toolbar;
  bool showStatusBar;
  int statusID;
  bool showToolBar;
  int toolID;
  int toolbar1;
  KPlotWindow* plotWin;

public slots:
  void mouseAt( double x, double y );
  void overview();

private slots:
  void toggleStatusBar();
  void toggleToolBar();

protected:
  virtual void paintEvent( QPaintEvent* e );

signals:
  void unzoom();
}; // class KPlotMainWindow

#endif
