#include <qobject.h>

RCSTAG( "$Id: kplot.cpp,v 1.28 1997/12/22 18:51:35 kde Exp $" );

#include <qkeycode.h>
#include <qpainter.h>
#include <qprinter.h>

#include <kapp.h>

#include "expression.h"
#include "koverview.h"
#include "kplot.moc"
#include "version.h"

#define __DEBUG

QList<KFunction>* functions;


KPlot::KPlot( int& argc, char** argv ) : KApplication( argc, argv )
{
  KPlotMainWindow* mainWindow = new KPlotMainWindow();
  CHECK_PTR( mainWindow );

  setMainWidget( mainWindow );
} // KPlot constructor


void
KPlot::print()
{
#ifdef __DEBUG
  debug( "KPlot::print" );
#endif

  QPrinter* printer = new QPrinter;
  CHECK_PTR( printer );

  printer->setup( mainWidget() );

  paintExpressions( printer );

  delete printer;
} // KPlot::print


void
KPlot::newExpression()
{
  KFunction* f = new KFunction;
  CHECK_PTR( f );
  f->text = "";
  f->pen = black;

  KSettingsDialog* dlg = new KSettingsDialog( f, mainWidget() );
  CHECK_PTR( dlg );
  if ( dlg->exec() ) {
    functions->append( f );

    emit expressionAdded();

    mainWidget()->repaint( TRUE );
  } // if
  else delete f;
} // KPlot::newExpression


void
KPlot::delExpression( uint index )
{
  functions->remove( index );
  emit expressionDeleted( index );
  mainWidget()->repaint( TRUE );
} // if} // KPlot::delExpression


KPlotMainWindow::KPlotMainWindow() : KTopLevelWidget( "KPlot main window" )
{
  setCaption( kapp->getCaption() );

  KMenuBar* mb = new KMenuBar( this, "menubar" );
  CHECK_PTR( mb );

  /* the file menu */
  QPopupMenu* qpmFile = new QPopupMenu;
  CHECK_PTR( qpmFile );
  qpmFile->insertItem( klocale->translate( "&Print" ), kapp,
		       SLOT( print() ), CTRL+Key_P );
  qpmFile->insertSeparator();
  qpmFile->insertItem( klocale->translate( "&Quit" ), kapp, SLOT( quit() ),
		       CTRL+Key_Q );
  
  mb->insertItem( klocale->translate( "&File" ), qpmFile );

  QPopupMenu* qpmExpr = new QPopupMenu;
  CHECK_PTR( qpmExpr );
  qpmExpr->insertItem( klocale->translate( "&New" ), kapp,
                       SLOT( newExpression() ), CTRL+Key_N );
  qpmExpr->insertItem( klocale->translate( "&Overview" ), this,
		       SLOT( overview() ) );
  mb->insertItem( klocale->translate( "&Expressions" ), qpmExpr );

  qpmOptions = new QPopupMenu;
  CHECK_PTR( qpmOptions );
  statusID = qpmOptions->insertItem( klocale->translate( "hide &status bar" ),
				     this, SLOT( toggleStatusBar() ) );
  toolID = qpmOptions->insertItem( klocale->translate( "hide &tool bar" ),
				   this, SLOT( toggleToolBar() ) );
  mb->insertItem( klocale->translate( "&Options" ), qpmOptions );

  // add a standard help menu
  float f = APP_VERSION;
  QString s1 = "KPlot V";
  QString s2;
  s2.setNum( f );
  s1 += s2;
  s1 += "\nMichael Ritzert <Ritzert@T-Online.de>";

  QPopupMenu* qpmHelp = kapp->getHelpMenu( FALSE, s1 );
  CHECK_PTR( qpmHelp );
  mb->insertSeparator();
  mb->insertItem( klocale->translate( "&Help" ), qpmHelp );
  
  setMenu( mb );

  toolbar = new KFunctionToolBar( this );
  CHECK_PTR( toolbar );
  addToolBar( toolbar );
  showToolBar = TRUE;

  plotWin = new KPlotWindow( this );
  CHECK_PTR( plotWin );
  setView( plotWin, TRUE );
  // to show the current cursor position in the status bar
  connect( plotWin, SIGNAL( mouseAt( double, double ) ),
	   SLOT( mouseAt( double, double ) ) );
  // the toolbar connects a signal to this signal
  connect( this, SIGNAL( unzoom() ), plotWin, SLOT( unzoom() ) );

  statusBar = new KStatusBar( this );
  CHECK_PTR( statusBar );
  setStatusBar( statusBar );
  showStatusBar = TRUE;
  statusBar->insertItem( "x = 0.000; y = 0.000", 1 );

  show();
} // KPlotMainWindow constructor


void
KPlotMainWindow::overview()
{
  KOverviewDlg* dlg = new KOverviewDlg( this );
  CHECK_PTR( dlg );
  dlg->exec();
  delete dlg;
} // KPlotMainWindow::overview


void
KPlotMainWindow::mouseAt( double x, double y )
{
  static QString sX, sY;
  sX.setNum( x );
  sY.setNum( y );
  statusBar->changeItem( "x = " + sX + "; y = " + sY, 1 );
} // KPlotMainWindow::mouseAt


void
KPlotMainWindow::toggleStatusBar()
{
  showStatusBar = !showStatusBar;
  if ( showStatusBar ) {
    enableStatusBar( KStatusBar::Show );
    qpmOptions->changeItem( klocale->translate( "hide &status bar" ),
			    statusID );
  } // if
  else {
    enableStatusBar( KStatusBar::Hide );
    qpmOptions->changeItem( klocale->translate( "show &status bar" ),
			    statusID );
  } // else
} // KPlotMainWindow::toggleStatusBar


void
KPlotMainWindow::toggleToolBar()
{
  showToolBar = !showToolBar;
  if ( showToolBar ) {
    enableToolBar( KToolBar::Show, toolbar1 );
    qpmOptions->changeItem( klocale->translate( "hide &tool bar" ), toolID );
  } // if
  else {
    enableToolBar( KToolBar::Hide, toolbar1 );
    qpmOptions->changeItem( klocale->translate( "show &tool bar" ), toolID );
  } // else
} // KPlotMainWindow::toggleToolBar


void
KPlotMainWindow::paintEvent( QPaintEvent* e )
{
  KTopLevelWidget::paintEvent( e );
  plotWin->repaint( e->rect(), TRUE );
} // paintEvent


int
main( int argc, char** argv )
{
  dictConstants = new QDict<double>;
  CHECK_PTR( dictConstants );
  dictConstants->setAutoDelete( TRUE );

  dictConstants->insert( "e", new double( M_E ) );
  dictConstants->insert( "pi", new double( M_PI ) );


  dictFunctions = new QDict<funcCall>;
  CHECK_PTR( dictFunctions );
  dictFunctions->setAutoDelete( TRUE );
  
  funcCall* fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = sin;
  dictFunctions->insert( "sin", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = cos;
  dictFunctions->insert( "cos", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = exp;
  dictFunctions->insert( "exp", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = sqrt;
  dictFunctions->insert( "sqrt", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = fabs;
  dictFunctions->insert( "abs", fc );

  // natural logarithm
  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = log;
  dictFunctions->insert( "ln", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = tan;
  dictFunctions->insert( "tan", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = asin;
  dictFunctions->insert( "asin", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = acos;
  dictFunctions->insert( "acos", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = atan;
  dictFunctions->insert( "atan", fc );
 
  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = cosh;
  dictFunctions->insert( "cosh", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = sinh;
  dictFunctions->insert( "sinh", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = tanh;
  dictFunctions->insert( "tanh", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = acosh;
  dictFunctions->insert( "acosh", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = asinh;
  dictFunctions->insert( "asinh", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = atanh;
  dictFunctions->insert( "atanh", fc );

  // logarith to the base of 10
  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = log10;
  dictFunctions->insert( "lg", fc );

  // cube root [x^(1/3)]
  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = cbrt;
  dictFunctions->insert( "cbrt", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = ceil;
  dictFunctions->insert( "ceil", fc );

  fc = new funcCall;
  CHECK_PTR( fc );
  fc->numParameters = 1;
  fc->oneParam = floor;
  dictFunctions->insert( "floor", fc );

  // create the functions list with the functions to plot
  functions = new QList<KFunction>;
  CHECK_PTR( functions );
  functions->setAutoDelete( TRUE );

  KPlot* app = new KPlot( argc, argv );
  CHECK_PTR( app );

  gridX = 1;
  gridY = 1;
  showGrid = grid_Dots;
  gridPenStyle = SolidLine;
  gridColor = gray;

  // actually run the app
  int nReturn = app->exec();

  // clean up
  delete app;
  return nReturn;
} // main

