/****************************************************************************
* Graphit
* By: Brian Horakh <nairb@connectnet.com> 
* Date: 1/15/96
*
* Purpose: Text Based Graphing Tool, that generates a graph based on data
*          which is passed to it on the command line.
*
* Licensing: GNU Copyleft, if you hack it, or distribute it, just go ahead and
*            send me piece of email. And you must distribute the source code
*            of any changes you make to it, along with the program.
*
* I did not add parameters because most people don't care. You'll find the
* type of Graph that suits your needs, and compile for it. Perhaps someday
* I'll actually write in Termcap and Color support!
*
* Designed for taking Ping times and generating a report, I designed the
* program under Linux, however it should work under most OS's. HOWEVER
* your version of ping may different output, in otherwords YMMV.
*
*  graphit `ping -c LINES HOSTIP | head --lines=LINES+1 | tail \
*          --lines=LINES | cut -d ' ' -f 7 | cut -b 6-20 | cut -d ' ' -f 1`
*
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

/* #define DEBUG */            /* If you want to watch the data its parsen */
/* #define ZEROSTART */        /* Define this if you want to Y at Zero */
/* #define SHOWVALUES */       /* If you want to show the values as well */
#define COLS 70                /* Total number of columns per page */
#define GRAPHSYM '*'           /* What character makes up the graph */

char *mkstr(int length, char c, char *buf)
{
 char *str;
 
 *(buf+length)=(char)0;
 while (length--)
    {
    *(buf+length)=c;
    }
 return(buf);
}

void main(int argc, char *argv[])
{
 float min, max;
 float scale;
 int x;
 char buf[COLS+2],tmp[25];
  
 min = -99999999;
 max = +99999999;
#ifdef DEBUG
 printf("\nArgument is: %d\n",argc);
#endif
 if (argc<=1)
    {  printf("Usage: graphit values\n"); 
       exit; }
       
 for (x=1;x<argc;x++)
     {
     float y;
     y = atof(argv[x]);
     if (x==1) { min=y; max=y; }          /* Preset Values */
#ifndef ZEROSTART
     if (min>y) { min=y; }
#endif
     if (max<y) { max=y; }
#ifdef DEBUG
     printf("%f/%f Y is: %f - Actual is: %s  - X is %d\n",min,max,y,argv[x],x);
#endif
     }

#ifdef ZEROSTART
     min=0;
#endif     
     
#ifdef DEBUG
 printf("\nMax: %f   Min: %f\n",max,min);
#endif

 scale = COLS/(max-min);
 mkstr(COLS,' ',&buf[0]);
 
 sprintf(&buf[0],"%1.1f",min);        
 buf[strlen(&buf[0])]=' ';
 
 if (COLS>10)
    { 
    sprintf(&buf[(COLS/2)-2],"%5.1f",(min+max)/2.0); 
    buf[ (COLS/2)-2+strlen( &buf[(COLS/2)-2] ) ]=' '; 
    }
    
 sprintf(&tmp[0],"%5.1f",max); 
 sprintf(&buf[ (COLS-strlen(tmp)) ],"%5.1f",max);
 
 printf("%s\n",buf); 
 printf("%s\n",mkstr(COLS,'-',&buf[0]));
 for (x=1;x<argc;x++)
      {
#ifdef SHOWVALUES
      if ( atof(argv[x]) <= min+8.0 )
      printf("|(%4.1f)%c\n",atof(argv[x]),GRAPHSYM);
      else
      printf("|%s(%4.1f)%c\n",mkstr( (int)(scale*(atof(argv[x])-min-8)) ,GRAPHSYM,&buf[0]),atof(argv[x]),GRAPHSYM);
#else
      if ( atof(argv[x]) <= min )
      printf("|%c\n",GRAPHSYM);
      else
      printf("|%s\n",mkstr( (int)(scale*(atof(argv[x])-min)) ,GRAPHSYM,&buf[0]));
#endif
      }
 
}