/* 
 * FPLOT - fplot.c
 *
 * Copyright (C) 1997 - 2000  Michael C. Ring
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 */

/*
 *      FAST/EASY postscript plotting program
 *
 *      see the individual mk* scripts/batch files to build
 *      the program under various OS's.
 *
 *      $Log: fplot.c,v $
 *      Revision 2.35  2000/01/17 21:32:18  mike
 *      comment out memory allocate/free debug message
 *
 *      Revision 2.33  2000/01/17 21:04:58  mike
 *      add set coordinates command
 *
 *      Revision 2.32  2000/01/13 04:21:41  mike
 *      add new grid line option
 *
 *      Revision 2.31  2000/01/10 04:24:26  mike
 *      add code to support variable graph borders
 *
 *      Revision 2.30  2000/01/09 04:59:12  mike
 *      add 'main' prototype for DOS compiles
 *
 *      Revision 2.29  2000/01/09 03:50:24  mike
 *      change g_buf to g_fields (kind of a dumb name in retrospect ...)
 *
 *      Revision 2.28  2000/01/08 06:51:28  mike
 *      fix log message that was too long from last check-in
 *
 *      Revision 2.27  2000/01/08 06:38:29  mike
 *      declare the global variables in glob.h by using 
 *      #define FPLOT_MAIN_MODULE
 *
 *      Revision 2.26  2000/01/08 06:14:22  mike
 *      added proto.h and full prototypes
 *
 *      Revision 2.25  1999/09/25 22:13:41  mring
 *      added new set pointsizescale command
 *
 *      Revision 2.21  1998/11/26 06:08:50  mring
 *      changed g_buf to use #defines (NF & CPF)
 *
 *      Revision 2.20  1998/10/16 23:13:57  mring
 *      added rotation option
 *
 *      Revision 2.11  1998/10/16 22:26:31  mring
 *      added MAX_LABELS
 *
 *      Revision 2.10  1998/04/03 20:35:40  mring
 *      set revision to 2.10 for the latest distribution package
 *
 *      Revision 2.0  1998/04/03 20:00:45  mring
 *      version of program is now the RCS version of this file
 *
 *      Revision 1.8  1998/03/15 23:21:57  mring
 *      update version to 0.6b
 *
 *      Revision 1.7  1998/03/07 04:41:55  mring
 *      update version to 0.6a
 *
 *      Revision 1.6  1998/03/05 03:42:35  mring
 *      update for 0.5a
 *
 *      Revision 1.5  1997/12/05 02:20:01  mring
 *      updated to version 0.4a
 *
 *      Revision 1.4  1997/11/26 23:18:02  mring
 *      added MAX_LINE_LENGTH
 *
 *      Revision 1.3  1997/11/24 01:30:23  mring
 *      *** empty log message ***
 *
 *      Revision 1.2  1997/11/24 01:27:35  mring
 *      added copyright notice
 *
 *      Revision 1.1  1997/11/23 23:15:01  mring
 *      Initial revision
 */

#include "fplot.h"
#include "proto.h"
#define FPLOT_MAIN_MODULE
#include "glob.h"
#undef  FPLOT_MAIN_MODULE

#ifdef  MSDOS
extern	int	main(int argc, char *argv[]);
#endif

static  char    
RCS_ID[] = "$Id: fplot.c,v 2.35 2000/01/17 21:32:18 mike Exp $";

/*
 *      Start of main source code
 */

int 	main(argc,argv)
int     argc;
char    *argv[];
{
int     k;
char    *buf, fn[256];
FILE    *in_ptr;

init_ctrl_c_handler();

init_globals();

if (argc < 2)
  {
   show_usage();
   exit_program(2);
  }

buf = g_input_string;
for (k=1; k < (argc - 1); k++)      /* process arguments */
  {
   strcpy(buf,argv[k]);

   if ((strcmp(buf,"-r") == 0) || (strcmp(buf,"-R") == 0))
     {
      g_raw_mode = TRUE;
     }
  }

get_tmp_file(g_tmp_file);           /* get a temp file       */
get_tmp_file(g_tmp_file2);          /* get another temp file */
get_tmp_file(g_tmp_file3);          /* get another temp file */

strcpy(fn,argv[argc - 1]);

if (strcmp(fn,"--") == 0)
   in_ptr = stdin;
else
  {
   if ((in_ptr = fopen(fn, "r")) == NULL)
     {
      fprintf(stderr,"File %s not found\n\n",fn);
      show_usage();
      exit_program(4);
     }
  }

g_tmp_ptr = fopen(g_tmp_file,"w");

while (fgets(g_input_string,MAX_LINE_LENGTH,in_ptr))
  {
   replace_crlf(g_input_string);
   fprintf(g_tmp_ptr,"%s\n",g_input_string);
  }

fclose(g_tmp_ptr);
g_tmp_ptr = NULL;

if (in_ptr != stdin)
  fclose(in_ptr);

if (g_raw_mode)     /* input file is just data */
  {
   plot_raw_file();
  }
else                /* input file is a command file */
  {
   plot_command_file();
  }

exit_program(0);
return(0);			    /* just to keep the compiler happy */
}
/***********************************************************************/
void	init_ctrl_c_handler()
{
if (signal(SIGINT, exit_program) == SIG_ERR)    /* Needed for graceful */
  {                                             /* shutdown            */
   fprintf(stderr,"ERROR : Couldn't set SIGINT\n");  
   abort();
  }

if (signal(SIGTERM, exit_program) == SIG_ERR)
  {
   fprintf(stderr,"ERROR : Couldn't set SIGTERM\n");  
   abort();
  }

/*
 *  additional signals to capture for non-dos (unix) systems
 */

#ifndef MSDOS

if (signal(SIGPIPE, exit_program) == SIG_ERR)
  {
   fprintf(stderr,"ERROR : Couldn't set SIGPIPE\n");  
   abort();
  }

if (signal(SIGHUP, exit_program) == SIG_ERR)
  {
   fprintf(stderr,"ERROR : Couldn't set SIGHUP\n");  
   abort();
  }

#endif
}
/***********************************************************************/
void	show_usage()
{
parse_line_into_fields(RCS_ID);

fprintf(stderr,
  "Usage : fplot [options] <filename>\t\t\t    [Version %s]\n\n",g_fields[4]);

fprintf(stderr,
     "        options  : -r  file is a raw data file, not a command file\n");

fprintf(stderr,
     "        filename : the file where to read commands from\n");
fprintf(stderr,
     "                   use -- to process stdin\n");
}
/***********************************************************************/
void	init_globals()
{
static  int first_time = TRUE;
int     k;
void    *vp;

if (first_time)
  {
   first_time = FALSE;
   g_raw_mode = FALSE;
   
   g_input_string = memory_allocate((MAX_LINE_LENGTH + 4) * sizeof(char));
   g_fields       = memory_allocate(NF * CPF * sizeof(char));

   g_big_buffer   = memory_allocate(BIG_BUF_SIZE * sizeof(char));

   g_plot_file    = memory_allocate(256 * sizeof(char));
   g_tmp_file     = memory_allocate(128 * sizeof(char));
   g_tmp_file2    = memory_allocate(128 * sizeof(char));
   g_tmp_file3    = memory_allocate(128 * sizeof(char));

   vp               = memory_allocate(MAX_LABELS_PLUS_1 * sizeof(char *));
   g_label_array    = vp;
   
   for (k=0; k <= MAX_LABELS; k++)   /* start index will normally be 1 */
     g_label_array[k] = NULL;        /* except for the first init      */   

   g_label_x        = memory_allocate(MAX_LABELS_PLUS_1 * sizeof(double));
   g_label_y        = memory_allocate(MAX_LABELS_PLUS_1 * sizeof(double));
   g_label_rotate   = memory_allocate(MAX_LABELS_PLUS_1 * sizeof(double));
   g_label_fontsize = memory_allocate(MAX_LABELS_PLUS_1 * sizeof(double));
   g_label_coord    = memory_allocate(MAX_LABELS_PLUS_1 * sizeof(int));

   /* the following 'small' allocates will be resized when needed */
   
   g_output_file  = memory_allocate(2 * sizeof(char));
   g_xlabel       = memory_allocate(2 * sizeof(char));
   g_y1label      = memory_allocate(2 * sizeof(char));
   g_y2label      = memory_allocate(2 * sizeof(char));
   g_title        = memory_allocate(2 * sizeof(char));

   g_tmp_file[0]  = '\0';
   g_tmp_ptr      = NULL;

   g_tmp_file2[0] = '\0';
   g_tmp_ptr2     = NULL;

   g_tmp_file3[0] = '\0';
   g_tmp_ptr3     = NULL;
  }

g_plot_file[0]         = '\0';
g_output_file[0]       = '\0';

for (k=1; k <= MAX_LABELS; k++)
  {
   if (g_label_array[k] != NULL)
     {
      memory_free(g_label_array[k]);
      g_label_array[k] = NULL;
     }

   g_label_x[k]        = 1.0;
   g_label_y[k]        = 1.0;
   g_label_coord[k]    = 1;             /* bit-mapped variable           */
   g_label_rotate[k]   = 0.0;
   g_label_fontsize[k] = 10.0;		/* update 'dfont' in fpout.c if  */
  }				        /* this constant (10.0) changes  */

g_xlabel[0]            = '\0';
g_y1label[0]           = '\0';
g_y2label[0]           = '\0';
g_title[0]             = '\0';

g_outputformat         = FORMAT_POSTSCRIPT;
g_xaxis_scale          = X_AXIS_SCALE_LINEAR;
g_graph_type           = GRAPH_TYPE_LINES;
g_gridlines            = GRID_LINES_ON;
g_usesamples           = FALSE;
g_force_y2_y1          = FALSE;        /* do not force Y2 range same as Y1 */

g_xrange_auto          = TRUE;         /* default to autoranging       */
g_y1range_auto         = TRUE;
g_y2range_auto         = TRUE;

g_num_y_ranges         = 0;
g_field_def_x          = 0;
g_field_def_y1         = 0;
g_field_def_y2         = 0;
g_field_def_y3         = 0;
g_field_def_y4         = 0;
g_field_def_y5         = 0;
g_field_def_y6         = 0;
g_field_def_y7         = 0;
g_field_def_y8         = 0;
g_field_def_y9         = 0;
g_field_def_y10        = 0;
g_field_def_y11        = 0;
g_field_def_y12        = 0;

g_skip_factor          = 0;
g_num_samples_to_plot  = 0;
g_usesamples_low       = 0;
g_usesamples_high      = 0;

g_point_size_scale     = 1.0;     
g_papersize_length     = 11.0;         /* in inches                    */
g_papersize_width      = 8.5;

g_border_left          = 1.0;          /* in inches                    */
g_border_top           = 1.0;
g_border_right         = 1.0;
g_border_bottom        = 1.0;

g_xmultiplier          = 1.0;
g_y1multiplier         = 1.0;
g_y2multiplier         = 1.0;

g_xoffset              = 0.0;
g_y1offset             = 0.0;
g_y2offset             = 0.0;

g_fontsize_title       = 14.0;         /* point size for these labels  */
g_fontsize_xlabel      = 14.0;
g_fontsize_y1label     = 14.0;         /* note : the variable 'dfont'  */
g_fontsize_y2label     = 14.0;         /*        in fpout.c will need  */
				       /*        to change if these    */
				       /*        defaults change       */

g_xrange_low           = 0.0;          /* x-axis lower limit           */
g_xrange_high          = 1.0;          /* x-axis upper limit           */
g_y1range_low          = 0.0;          /* y1-axis lower limit          */
g_y1range_high         = 1.0;          /* y1-axis upper limit          */
g_y2range_low          = 0.0;          /* y2-axis lower limit          */
g_y2range_high         = 1.0;          /* y2-axis upper limit          */
}
/***********************************************************************/
void    exit_program(code)
int     code;
{
int     k;

signal(SIGINT, SIG_IGN);          /* now that we're in here, ignore ^C */

if (g_tmp_file[0] != '\0')
  {
   if (g_tmp_ptr != NULL)
     fclose(g_tmp_ptr);

   delete_file(g_tmp_file);
  }

if (g_tmp_file2[0] != '\0')
  {
   if (g_tmp_ptr2 != NULL)
     fclose(g_tmp_ptr2);

   delete_file(g_tmp_file2);
  }

if (g_tmp_file3[0] != '\0')
  {
   if (g_tmp_ptr3 != NULL)
     fclose(g_tmp_ptr3);

   delete_file(g_tmp_file3);
  }

if (code < 80)
  {
   for (k=1; k <= MAX_LABELS; k++)
     {
      if (g_label_array[k] != NULL)
	{
	 memory_free(g_label_array[k]);
	 g_label_array[k] = NULL;
	}
     }
   
   memory_free(g_input_string);
   memory_free(g_fields);

   memory_free(g_label_array);
   memory_free(g_label_x);
   memory_free(g_label_y);
   memory_free(g_label_rotate);
   memory_free(g_label_fontsize);
   memory_free(g_label_coord);

   memory_free(g_xlabel);
   memory_free(g_y1label);
   memory_free(g_y2label);
   memory_free(g_title);

   memory_free(g_plot_file);
   memory_free(g_big_buffer);
   memory_free(g_tmp_file);
   memory_free(g_tmp_file2);
   memory_free(g_tmp_file3);
   memory_free(g_output_file);

   /* un-comment the following for malloc/free debug */

   /*
   if ((k = get_malloc_free_counter()) != 0)
     {
      fprintf(stderr,"FPLOT WARNING! : (malloc - free) calls should = 0\n");
      fprintf(stderr,"                  malloc free counter = %d\n",k);
     }
   */
  }

exit(code);
}
/***********************************************************************/
