/*
   fofx: function grapher for ASCII terminals
   Copyright (C) 1997 Tom Stepleton

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
   fofx.h: support and options for fofx
*/

#define MAX_COLUMNS 256               /* Edit these to your liking */
#define MIN_COLUMNS 24
#define DECIMAL_SEPARATOR '.'              /* International users? */
#define THOUSAND_SEPARATOR ','
#define DETERMINANT_H 0.0000001      /* Depending on the precision */
                                  /* of your architecture's double */
                              /* type, you may wish to change this */
 
#define VARIABLE 1                       /* No more editable items */
#define NUMBER 2

/* External function declarations */
  /* main.c */
extern void fatal_error(int err1,int err2);
  /* preparse.c */
extern void preparse(unsigned char *phrase, unsigned char token);
extern unsigned char *all_lcase(unsigned char *thestring);
  /* parse.c */
extern void ParseCmdLine(int argc, unsigned char *argv[]);
extern double DoEquation(void);
extern void DoAddition(double *answer);
extern void DoMultiplication(double *answer);
extern void DoExponent(double *answer);
extern void DoUnaries(double *answer);
extern void DoParentheses(double *answer);
extern void NextToken(void);
extern void GetNumber(double *answer);
extern int isdelim(unsigned char thechar);
extern int isunary(unsigned char thechar);
  /* graph.c */
/*
extern void GraphEquation(void);
extern char DoDeterminant(double *answer);
extern void init_axes(double *x_axis_approx, double *y_axis_approx);
extern char isaxis(double y, double x_axis_approx, double y_axis_approx);
*/
extern void GraphEquation(void);
extern char DoDeterminant(double *answer);
extern void calc_and_plot(char plane_char);

/* Globals */
extern int deg,cols;
extern int xaxis,yaxis;
extern double iv;
extern double tlx,tly;
extern double brx,bry;
extern double Variable;
extern unsigned char *function, *func_ptr, token[80];
extern int token_type;
extern char *progname;

/* Function Token Tables */
static unsigned char *function_phrases[] = {
"asin","acos","atan",
"sinh","cosh","tanh",
"sin","cos","tan",
"log","ln",
"sqrt",
"abs"
};

static unsigned char function_tokens[] = {
0x83,0x84,0x85,
0x86,0x87,0x88,
0x80,0x81,0x82,
0x89,0x8a,
0x8b,
0x8c,'\0'
};
