/*
 * Implementation of concrete LinearRegression fitter.
 *
 */


#include <iostream.h>
#include "debug.h"
#include "linreg.h"
#include "resultwindow.h"


REGISTER_FITTER(LinearRegression);


LinearRegression::LinearRegression ()
{
   slope = intercept = 0.0;
}

int LinearRegression::execOptionsDialog ()
{
   return 0;
}

int LinearRegression::getInputColumnCount ()
{
   return 2;
}

int LinearRegression::getOutputColumnCount ()
{
   return 2;
}

const char* LinearRegression::getInputColumnName (int i)
{
   switch (i) {
   case 0: return "X";
   case 1: return "Y";
   default: return "You don't like index checks, duh?";
   }
}

const char* LinearRegression::getOutputColumnName (int i)
{
   switch (i) {
   case 0: return "X linear";
   case 1: return "Y linear";
   default: return "You don't like index checks, duh?";
   }
}

bool LinearRegression::fit ()
{
   int i, n;
   double s1, s2, s3, s4, xi, yi;
   QString st;
   char s[255];

   IFDEBUG("korigin.fitter",2)
	 cout << "LinearRegression::fit() started." << endl;
   ENDDEBUG;
   IFDEBUG("korigin.fitter",3)
	 cout << "LinearRegression::fit() " << inputColumns[1].title()
		  << " over " << inputColumns[0].title() << endl;
   ENDDEBUG;

   if (inputColumns[0].type() != Column::columnDouble) return false;
   if (inputColumns[1].type() != Column::columnDouble) return false;
   if (outputColumns[0].type() != Column::columnDouble) return false;
   if (outputColumns[1].type() != Column::columnDouble) return false;

   n = inputColumns[0].dim();
   s2 = s2 = s3 = s4 = 0.0;

   // S1 = sum xi * yi
   // S2 = sum xi
   // S3 = sum yi
   // S4 = sum x^2
   for (i=0; i<n; i++)
   {
      xi = inputColumns[0][i];
      yi = inputColumns[1][i];
      s1 += xi * yi;
      s2 += xi;
      s3 += yi;
      s4 += xi * xi;
   }

   slope = ((double)n * s1 - s2 * s3) / ((double)n * s4 - s2 * s2);
   intercept = (s3 - slope * s2) / (double)n;

   // output slope and intercept into resultswindow.
   result->insertLine ("Linear Regression Results:");
   result->insertLine ("-------------------");
   st = QString("Dataset: ");
   st += " using ";
   st += inputColumns[1].title();
   st += " over ";
   st += inputColumns[0].title();
   result->insertLine ((const char*)st);
   result->insertLine ("");
   result->insertLine ("Fitfunction:      y = m * x + b");
   result->insertLine ("");
   sprintf (s, "m = %g\t\tdelta_m = ", slope);
   result->insertLine (s);
   sprintf (s, "b = %g\t\tdelta_b = ", intercept);
   result->insertLine (s);
   result->insertLine ("");

   IFDEBUG("korigin.fitter",3)
	 cout << "LinearRegression::fit() slope = " << slope
		  << ", intercept = " << intercept << endl;
   ENDDEBUG;

   outputColumns[0].setTitle(getOutputColumnName(0));
   outputColumns[1].setTitle(getOutputColumnName(1));
   for (i=0; i<n; i++)
	 {
	   outputColumns[0][i] = inputColumns[0][i];
	   outputColumns[1][i] = intercept +
		 slope * inputColumns[0][i];
	 }
   IFDEBUG("korigin.fitter",2)
	 cout << "LinearRegression::fit() output to " 
		  << outputColumns[0].title() << " and "
		  << outputColumns[1].title() << endl;
   ENDDEBUG;
   IFDEBUG("korigin.fitter",2)
	 cout << "LinearRegression::fit() finished." << endl;
   ENDDEBUG;
   return true;
}

void LinearRegression::saveSettings (KConfig*)
{
}

void LinearRegression::loadSettings (KConfig*)
{
}
