/*
 *  The Worksheet for the Korigin project
 *
 *  I have to cut this project in several parts to
 *  get more clear design. In the moment, including
 *  new features is more important for me.
 *
 *  (C) 1997/98 
 *
 *  Written by Martin Hfner for the Korigin project.
 *
 */


#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <ctype.h> 

#include <qpainter.h>
#include <qkeycode.h>
#include <qprinter.h>
#include <qcolor.h>
#include <qmsgbox.h>
#include <qaccel.h>
#include <qpixmap.h>
#include <qclipbrd.h>
#include <qfiledlg.h>

#include <kiconloader.h>

#include "worksheet.h"
#include "export.h"
#include "plot.h"
#include "ws_calculatewidget.h"
#include "ws_sort.h"
#include "tree.h"

// include the moc file here, so I don't need to compile it alone
#include "worksheet.moc"

#define ACTIVE_WORKSHEET "table-a.xpm"
#define INACTIVE_WORKSHEET "table-i.xpm"

//
// this is a very important pointer for the main menu
//
Worksheet* activeWS = 0;

// init the static member of worksheet which controls names of worksheets
// names are not allowed to appear double
QList<QString> Worksheet::givenWSNames;


// *****************************  Worksheet  **********************************

QString extractBehindEqual (const char* line)
{
  QString s = line;

  s = s.stripWhiteSpace ();

  s = s.right(s.length()-s.find("=")-1);

  return (s);
}


QString getNextEntry (QString s)
{
  int l;

  s = s.stripWhiteSpace();

  l = s.find ("\t");
  if (l<0) l = s.length();

  s = s.left (l);
  s = s.stripWhiteSpace ();

  return (s);
}


//
// strips extry out of s and also strips whitespaces at begin and end of
// the string
//

QString stripEntry (QString s, QString entry)
{
  QString dummy;

  // get the rest of the string and strip whitespaces
  dummy = s.remove (0, entry.length());

  dummy = dummy.stripWhiteSpace ();

  return (dummy);
}


const char* Worksheet::name ()
{
  return (T->name ());
}


QList<Worksheet>& Worksheet::list ()
{
  static QList<Worksheet> the_worksheet_list;
  return the_worksheet_list;
}


Worksheet* Worksheet::findWorksheet (const char* name)
{
  uint i;
  for (i=0; i<list().count(); i++) {
	cout << "compare \"" << list().at(i)->caption()
		 << "\" with \"" << name << "\"" << endl;
	if (strcmp(list().at(i)->caption(),name) == 0)
	  return list().at(i);
  }
  return 0;
}


Column Worksheet::findColumn (const char* name)
{
  return ( T->column ( T->findColumn(name) ) );
}


Worksheet* Worksheet::loadFromDisk (QFile* file)
{
  int i, j;
  int numberCols, numberRows;
  char line[MAXLEN];
  QString name, s, dummy1;

  Worksheet* WS = new Worksheet ();
  
  // number of columns
  file->readLine (line, MAXLEN);
  numberCols = atoi ((const char*)extractBehindEqual (line));
  
  // number of rows
  file->readLine (line, MAXLEN);
  numberRows = atoi ((const char*)extractBehindEqual (line));
  
  // worksheets name
  file->readLine (line, MAXLEN);
  name = extractBehindEqual (line);
  
  file->readLine (line, MAXLEN);
  
  Table* t = new Table ();
  
  for (i=0; i<numberCols; i++)
    {
      file->readLine (line, MAXLEN);
      
      if (extractBehindEqual (line) == QString ("double"))
	t->insertColumn (i, Column(Column::columnDouble));
      else 
	t->insertColumn (i, Column(Column::columnString));
    }
  
  file->readLine (line, MAXLEN);
  file->readLine (line, MAXLEN);
  
  
  // the headline...
  file->readLine (line, MAXLEN);
  s = line;
  
  for (i=0; i<numberCols; i++)
    {
      dummy1 = getNextEntry (s);
      
      // sicher ist sicher...
      if (dummy1.length() == 0) 
	{
	  dummy1 += 'A' + (i/26);
	  dummy1 += 'A' + (i%26);
	}
      
      t->setTitle ( i, (const char*)dummy1 );
      
      s = stripEntry (s, dummy1);
    }
  
  
  // now the data...
  i = 0;
  for (j=0; j<numberRows; j++)
    {
      file->readLine (line, MAXLEN);
      
      s = line;
      s = s.stripWhiteSpace ();
      
      while ( s.length() > 0 )
	{
	  if ((dummy1 = getNextEntry (s)).length() == 0 ) break;
	  
	  t->setCell (i, j, (const char*)dummy1);
	  
	  i++;
	  
	  // get the rest of the string and strip whitespaces
	  s = stripEntry (s, dummy1);
	}
      
      i = 0;
    }
  // end of data
  file->readLine (line, MAXLEN);
  file->readLine (line, MAXLEN);

  // the notes section
  file->readLine (line, MAXLEN);      // the <notes segment> line
  file->readLine (line, MAXLEN);      // the first note line
  while (strcmp(line, "</notes segment>\n") != 0)
    {
      WS->notes += line;
      file->readLine (line, MAXLEN);
    }
  file->readLine (line, MAXLEN);

  t->setName (name);
  WS->setTable (t);
  
  // now go on with the formulas
  for (i=0; i<numberCols; i++)
    {
      file->readLine (line, MAXLEN);
      WS->formulaData[i]->formula = extractBehindEqual (line);
      
      file->readLine (line, MAXLEN);
      WS->formulaData[i]->constants = extractBehindEqual (line);
      
      file->readLine (line, MAXLEN);
      WS->formulaData[i]->min = extractBehindEqual (line).toInt();
      
      file->readLine (line, MAXLEN);
      WS->formulaData[i]->max = extractBehindEqual (line).toInt();
    }
  
  // go on with usage
  file->readLine (line, MAXLEN);
  
  for (i=0; i<numberCols; i++)
    {
      file->readLine (line, MAXLEN);
      WS->usage.at(i)->QString(extractBehindEqual (line));
    }

  return WS;
}


Worksheet* Worksheet::openWorksheetFromDisk ()
{
  QString filename;
  Worksheet* WS = 0;
  char line[MAXLEN];

  KConfig* k = KApplication::getKApplication()->getConfig ();
  k->setGroup ("Worksheet");

  QFileDialog* filedlg;
  filedlg = new QFileDialog(0, "*.kow", 
			    0, "", TRUE);

  QString capt = QString ("Open Worksheet");

  filedlg->setCaption(capt);

  filedlg->setDir((const char*)k->readEntry ("WSPath", getenv ("HOME")) );
  
  int result = filedlg->exec ();
  filename = filedlg->selectedFile();

  if (filename.right (4) != QString(".kow")) filename+=".kow";

  if (result == 1)
    {
      // save to disk
      QFile* file = new QFile ((const char*)filename);

      if (file->exists () != TRUE) 
	{
	  QMessageBox::warning (0, "Warning", 
				    "File does not exist.");
	  delete file;
	  delete filedlg;
	  return WS;
	}

      // now load file...
      file->open (IO_ReadOnly);

      // read the "<worksheet>" entry
      file->readLine (line, MAXLEN);
	  if (strcmp(line,"<worksheet>\n") == 0)
		WS = loadFromDisk (file);
	  else
    {
	  QMessageBox::warning (0, "Error:", 
							"Not in worksheet format.");
	}
      delete file;
    }

  delete filedlg;
  return WS;
}


void Worksheet::saveWorksheetAs ()
{
  QString filename;
  int i;
  KConfig* k = KApplication::getKApplication()->getConfig ();
  k->setGroup ("Worksheet");

  QFileDialog* filedlg;
  filedlg = new QFileDialog(0, "*.kow", 
			    0, "", TRUE);

  QString capt = QString ("Save Worksheet as ");

  filedlg->setCaption(capt);

  filedlg->setDir((const char*)k->readEntry ("WSPath", getenv ("HOME")) );
  
  int result = filedlg->exec ();
  filename = filedlg->selectedFile();

  if (filename.right (4) != QString(".kow")) filename+=".kow";

  if (result == 1)
    {
      // save to disk
      QFile* file = new QFile ((const char*)filename);

      if (file->exists () == TRUE) 
	{
	  i = QMessageBox::warning (0, "Warning", 
				    "File already exists!\n\nOverwrite it?",
				    "Yes", "No");
	  // stop if necessary...
	  if (i==1) 
	    {
	      delete file;
	      delete filedlg;
	      return;
	    }
	}

      file->open (IO_WriteOnly);

      saveToDisk (file);

      file->close ();
      delete file;
    }

  delete filedlg;
}


void Worksheet::saveToDisk (QFile* file)
{
  char help[255];
  char help1[100];
  int i, j;

  file->writeBlock ("<worksheet>\n", strlen ("<worksheet>\n"));

  strcpy (help, "columns=");
  sprintf (help1, "%i\n", T->width());
  strcat (help, help1);
  file->writeBlock (help, strlen(help));

  strcpy (help, "rows=");
  sprintf (help1, "%i\n", T->height());
  strcat (help, help1);
  file->writeBlock (help, strlen(help));

  strcpy (help, "name=");
  strcat (help, (const char*)T->name());
  strcat (help, "\n\n");
  file->writeBlock (help, strlen(help));

  // the column types
  for (i=0; i<T->width(); i++)
    {
      strcpy (help, "column");
      sprintf (help1, "%i=", i);
      strcat (help, help1);
      if (T->type(i)==Column::columnDouble) strcat (help, "double");
      else strcat (help, "string");
      strcat (help, "\n");
      file->writeBlock (help, strlen (help));
    }
  
  file->writeBlock ("\n", strlen ("\n"));

  // now the data segment
  file->writeBlock ("<Data segment>\n", strlen("<Data segment>\n"));

  // headings...
  for (i=0; i<T->width(); i++)
    {
      strcpy (help, (const char*)T->title (i));
      strcat (help, "\t");
      file->writeBlock (help, strlen (help));
    }
  file->writeBlock ("\n", strlen ("\n"));

  // cell contents...
  for (j=0; j<T->height(); j++)
    {
      for (i=0; i<T->width(); i++)
	{
	  strcpy (help, (const char*)T->cell (i, j));
	  strcat (help, "\t");
	  file->writeBlock (help, strlen (help));
	}
      file->writeBlock ("\n", strlen ("\n"));
    }

  file->writeBlock ("</Data segment>\n\n", strlen("</Data segment>\n\n"));

  // the worksheets notes
  file->writeBlock ("<notes segment>\n", strlen("<notes segment>\n"));
  file->writeBlock ((const char*)notes, strlen ((const char*)notes));
  file->writeBlock ("\n", strlen ("\n"));
  file->writeBlock ("</notes segment>\n\n", strlen("</notes segment>\n\n"));

  // now the formula segment
  for (i=0; i<T->width(); i++)
    {
      // formula itself
      strcpy (help, "formula");
      sprintf (help1, "%i=", i);
      strcat (help, help1);
      strcat (help, (const char*)formulaData[i]->formula);
      strcat (help, "\n");
      file->writeBlock (help, strlen (help));

      // local constants
      strcpy (help, "constants");
      sprintf (help1, "%i=", i);
      strcat (help, help1);
      strcat (help, (const char*)formulaData[i]->constants);
      strcat (help, "\n");
      file->writeBlock (help, strlen (help));

      // min and max rows
      strcpy (help, "minrow");
      sprintf (help1, "%i=", i);
      strcat (help, help1);
      sprintf (help1, "%i\n", formulaData[i]->min);
      strcat (help, help1);
      file->writeBlock (help, strlen (help));

      strcpy (help, "maxrow");
      sprintf (help1, "%i=", i);
      strcat (help, help1);
      sprintf (help1, "%i\n", formulaData[i]->max);
      strcat (help, help1);
      file->writeBlock (help, strlen (help));
    }

  file->writeBlock ("\n", strlen ("\n"));
  // the column usage
  QString* iter;
  for (iter=usage.first(); iter!=0; iter=usage.next())
    {
      strcpy (help, "usageCol");
      sprintf (help1, "%i=", usage.at());
      strcat (help, help1);
      strcat (help, (const char*)iter->copy());
      strcat (help, "\n");
      file->writeBlock (help, strlen (help));
    }
}


void Worksheet::resetColumnUsage ()
{
  int i;
  KConfig* k = KApplication::getKApplication()->getConfig ();
  k->setGroup ("Worksheet");

  while (usage.removeLast () == TRUE) ;

  usage.append (new QString ( k->readEntry("defaultPlot-0", 
				    Plots().first()->paramName(0)) ) );

  for (i=1; i<T->width(); i++)
    {
      usage.append (new QString ( k->readEntry("defaultPlot-1", 
				    Plots().first()->paramName(1)) ) );
    }
}


// if _numCols = 0 no memory will be allocated

Worksheet::Worksheet (int _numRows, int _numCols, QWidget* parent, const char* name)
  : QWidget (parent, name)
  {
    int i;
    QString s;
    setBackgroundColor (TABLE_BG_COLOR);
    high = new Highlighted ();

    T = new Table();

	the_treeitem = 0;
	treeitem();

    // get new memory and the column IDs from Mr. M
    for (i=0; i<_numCols; i++)
      {
	T->insertColumn (i, Column(Column::columnDouble));

        s = "";
        s += 'A' + (i / 26);
        s += 'A' + (i % 26);

        T->setTitle ( i, (const char*)s);
      }
    
    // set the formulaData struct - be careful, 'cause memory will only
    // be allocated till numCols 
    formulaData = new fiData* [MAXCOLS];
    for (i=0; i<_numCols; i++)
      {
	formulaData[i] = new fiData;

	formulaData[i]->formula = "";
	formulaData[i]->constants = "";
	formulaData[i]->min = 1;
        formulaData[i]->max = _numRows;
      }

    //
    // set the window and dataset title (finds a completely new name)
    //
    setName ();
    setCaption ((const char*)T->name());

    // initialize Widget Pointers to 0 - only necessary with non-modal widgets
    ws_info = 0;
    insColW = 0;
    insRowW = 0;
    chColName = 0;
    gotoW = 0;
    deleteRowW = 0;
    deleteColW = 0;
    colStatW = 0;
    rowStatW = 0;
    normColW = 0;
    calcW = 0;

    // define the three TableViews with or without initial size
    if ( (_numCols > 0) && (_numRows > 0) )
      {
	Tdata = new TableData (_numRows, _numCols, this);        // (row, col)
	Thead = new TableHead (_numCols, this);
	TfiCol = new TableFirstColumn (_numRows, this);

	// needed for displaying the whole table(a problem of Table::getHeight)
	T->setCell (0,_numRows-1, "garbage!");
      }
    else 
      {
	Tdata = new TableData (0, 0, this);
	Thead = new TableHead (0, this);
	TfiCol = new TableFirstColumn (0, this);		      
      }

    // only show whole columns and rows
    setSizeIncrement (CELLWIDTH, CELLHEIGHT);

    setMinimumSize (FIRSTCELLWIDTH+2*CELLWIDTH+16+1, 
		    FIRSTCELLHEIGHT+2*CELLHEIGHT+16+1);
    setMaximumSize (T->width()*CELLWIDTH+FIRSTCELLWIDTH+1+16, 
		    T->height()*CELLHEIGHT+FIRSTCELLHEIGHT+16);

    resize(FIRSTCELLWIDTH+3*CELLWIDTH+16+1,9*CELLHEIGHT+FIRSTCELLHEIGHT+16+1);

    // reset the columns usage string
    usage.setAutoDelete (TRUE);
    resetColumnUsage ();

    // define the PopupMenus, but don't show them
    insertPop = new QPopupMenu ();
    insertPop->insertItem ("Data", this, SLOT (showInsertData ()));
    insertPop->insertItem ("Label", this, SLOT (showInsertLabel ()));

    //
    // now build the setAs Popup from the list of available Plots.
    //
    QPopupMenu* setAsPop = new QPopupMenu ();
    QPopupMenu* setAsPopLabel = new QPopupMenu ();
    
    Plot* iter;
    for (iter=Plots().first(); iter!=0; iter=Plots().next())
      {
	for (i=0; i<iter->paramCount (); i++)
	  {
	    setAsPop->insertItem (iter->paramName(i));
	    setAsPopLabel->insertItem (iter->paramName(i));
	  }
	if (Plots().at() == int(Plots().count()-1));
	else 
	  {
	    setAsPop->insertSeparator ();
	    setAsPopLabel->insertSeparator ();
	  }
      }

    connect (setAsPop, SIGNAL (activated (int)), 
	     SLOT (setAsPopSelected (int)));
    connect (setAsPopLabel, SIGNAL (activated (int)), 
	     SLOT (setAsPopSelected (int)));

    //
    // end of setAs Popup
    //

    // several popups, depending on the column data format
    dataColPop = new QPopupMenu ();
    dataColPop->insertItem ("Change...", this, SLOT (showChColName()));
    dataColPop->insertSeparator ();
    dataColPop->insertItem ("Set As...", setAsPop);
    dataColPop->insertSeparator ();
    dataColPop->insertItem ("Insert", insertPop);
    dataColPop->insertItem ("Delete", this, SLOT (showDeleteColumn()));
    dataColPop->insertSeparator ();
    dataColPop->insertItem ("Goto Column", this, 
			    SLOT (showGotoColumnWidget ()));
    dataColPop->insertSeparator ();
    dataColPop->insertItem ("Set Column Values", this, 
			    SLOT (showCalculateWidget ()));
    dataColPop->insertItem ("Normalize", this, SLOT (showNormalizeColumn ()));
    dataColPop->insertItem ("Column Statistics", this, 
			    SLOT (showColStatWidget()));
    dataColPop->insertItem ("Sort", this, SLOT (sortWorksheetByData ()));
    
    rowPop = new QPopupMenu ();
    rowPop->insertItem ("Insert", this, SLOT (showInsertRowWidget ()));
    rowPop->insertItem ("Delete", this, SLOT (showDeleteRow ()));
    rowPop->insertSeparator ();
    rowPop->insertItem ("Goto Row", this, SLOT (showGotoRowWidget ()));
    rowPop->insertSeparator ();
    rowPop->insertItem ("Row Statistics",this, SLOT (showRowStatWidget()));

    insertPop = new QPopupMenu ();
    insertPop->insertItem ("Data", this, SLOT (showInsertData ()));
    insertPop->insertItem ("Label", this, SLOT (showInsertLabel ()));

    labelColPop = new QPopupMenu ();
    labelColPop->insertItem ("Change Name", this, SLOT (showChColName ()));
    labelColPop->insertSeparator ();
    labelColPop->insertItem ("Set As...", setAsPopLabel);
    labelColPop->insertSeparator ();
    labelColPop->insertItem ("Insert", insertPop);
    labelColPop->insertItem ("Delete", this, SLOT (showDeleteColumn ()));
    labelColPop->insertSeparator ();
    labelColPop->insertItem ("Goto Column", this, 
			     SLOT (showGotoColumnWidget ()) );

    insertPop = new QPopupMenu ();
    insertPop->insertItem ("Data", this, SLOT (showInsertData ()));
    insertPop->insertItem ("Label", this, SLOT (showInsertLabel ()));

    mainPop = new QPopupMenu ();
    mainPop->insertItem ("Information", this, 
			 SLOT (showWorksheetInfoWidget()));
    mainPop->insertSeparator ();
    mainPop->insertItem ("Append new Columns", this, 
			 SLOT (showAppendColumnWidget()));
    mainPop->insertItem ("Append new Rows", this,SLOT (showInsertRowWidget()));
    mainPop->insertSeparator ();
    mainPop->insertItem ("Clear Worksheet", this,SLOT (showClearWorksheet()));
    mainPop->insertSeparator ();
    mainPop->insertItem ("Save", this, SLOT (saveWorksheetAs()));
    mainPop->insertItem ("Save as...", this, SLOT (saveWorksheetAs()));
    mainPop->insertItem ("Export...", exportFilter::getExportFilterPopup ());

    mainPop->insertSeparator ();
    mainPop->insertItem ( "Cut", this, SLOT (cut()) );
    mainPop->insertItem ( "Copy", this, SLOT (copy()) );
    mainPop->insertItem ( "Paste", this, SLOT (paste()) );
    mainPop->insertItem ( "Select all", this, SLOT (selectAll()) );

    QAccel *a = new QAccel( this );      
    a->connectItem ( a->insertItem (CTRL+Key_Insert), this, SLOT (copy()) );
    a->connectItem ( a->insertItem (SHIFT+Key_Insert), this, SLOT(paste()) ); 
    a->connectItem ( a->insertItem (Key_Delete), this, SLOT (cut()) );
    a->connectItem ( a->insertItem (Key_PageDown), this, SLOT (PgDown()) );
    a->connectItem ( a->insertItem (Key_PageUp), this, SLOT (PgUp()) );

    // here the "real SIGNALS" to change the first cell are connected with
    // their SLOTS
    connect (Tdata, SIGNAL (topCellHasChanged (int)), 
	     TfiCol, SLOT (changeTopCell (int)));
    connect (Tdata, SIGNAL (leftCellHasChanged (int)), 
	     Thead, SLOT (changeLeftCell (int)));

    connect (Thead, SIGNAL (showPopup(QPoint)),SLOT (showColumnPopup(QPoint)));
    connect (TfiCol, SIGNAL (showPopup(QPoint)), SLOT (showRowPopup(QPoint)));

    //
    // define the popup that will be returned to the main widget
	// OBSOLETE: is now generated in getMenu()!
    //

    //
    // define the edit menu sent to the main widget
	// OBSOLETE: is now generated in getEditMenu()!
    //

    connect (Thead, SIGNAL (changeActiveWS()), SLOT (changeActiveWS())); 
    connect (Tdata, SIGNAL (changeActiveWS()), SLOT (changeActiveWS()));
    connect (TfiCol, SIGNAL (changeActiveWS()), SLOT (changeActiveWS()));

    repaint ();

    return;
  }


void Worksheet::setAsPopSelected (int number)
{
  //
  // number is the row number within the popup from top starting on 0 
  //

  // set Plots list on head
  Plots().at (0);
  
  while (Plots().current()->paramCount() < number)
    {
      number -= Plots().current()->paramCount();

      // dont forget the separator
      number -= 1;
      Plots().next();
    }

  // set the usage of the column and repaint the column head
  usage.at(curCol)->QString (Plots().current()->paramName(number));

  Thead->update (curCol);  
}


void Worksheet::sortWorksheetByData ()
{
  if (high->isColumnHighlighted (curCol));
  else 
    {
      high->setMouseStartPos (QPoint (curCol, 0), "Thead");
      high->setMouseEndPos (QPoint (curCol, T->height()));
      repaint ();
    }

  WsSort* sort = new WsSort (0, T->title(curCol));

  int result = sort->exec ();
  if (result == 1)
    {
      if (sort->getSortType () == QString ("Ascending"))
	{
	  cout << "Sorting upwards" << endl;
	  
	}
      else 
	{
	  cout << "Sorting downwards" << endl;
	}
    }

  delete sort;
}


void Worksheet::changeActiveWS ()
{
  Worksheet* oldActive = activeWS;

  cout << "Now emit signal \"activeWSChanged\"..." << endl;
  emit activeWSChanged(this);

  if (oldActive) {
	oldActive->the_treeitem->setText(oldActive->getDescription());
	oldActive->the_treeitem->setPixmap(oldActive->getSymbol());
  }
  the_treeitem->setText(getDescription());
  the_treeitem->setPixmap(getSymbol());
  emit treeItemChanged();
}


QString Worksheet::findName (const char* name)
{
  QString WSName;
  char s[10];
  int occurs;
  QString* iter;
	     
  // iterate through the list and check for given names
  int count=1;
  
  do
    {
      // how often occurs the name in the list
      occurs=0;
      
      // build new worksheet name (data-1, data-2, data-3 ... or
      // "name"-1, "name"-2 ...)
      if (name == 0) 
	{
	  WSName = QString ("data-");
	  sprintf (s, "%i", count);
	  WSName += s;
	}
      else 
	{
	  WSName = QString (name);
	  if (count > 1)
	    {
	      sprintf (s, "-%i", count);
	      WSName += s;
	    }
	}
      
      for (iter=Worksheet::givenWSNames.first(); iter!=0;
	   iter=Worksheet::givenWSNames.next())
	{
	  if (*iter == WSName) occurs++;
	}
      // no occurancy -> ok
      if (occurs == 0) break;
      
      // one occurancy and only on active WS -> also ok
      if ((occurs == 1) && (T->name() == WSName)) break;
      
      count++;
    }
  while (1==1);   // Endlosschleife
  
  // now return the new found not used name for the worksheet
  return (WSName);
}


void Worksheet::setName (const char* name)
{
  QString newName = findName (name);

  Worksheet::givenWSNames.append (new QString (newName));
  T->setName (newName);

  the_treeitem->setText(getDescription());
  emit treeItemChanged();
}


void Worksheet::changeName (const char* name)
{
  QString newName = findName (name);
  QString* iter;

  for (iter=Worksheet::givenWSNames.first(); iter!=0;
	   iter=Worksheet::givenWSNames.next())
	{
	  if (*iter == T->name()) 
	    {
	      // first remove the old entry
	      Worksheet::givenWSNames.remove ();
	      Worksheet::givenWSNames.append (new QString (newName));
	      T->setName (newName);
		  the_treeitem->setText(getDescription());
		  emit treeItemChanged();
	      break;
	    }
	}
}


// ***************  build the export menu and slots  **************************


void Worksheet::slotExportTable (int i)
{
  exportFilterList().at(i)->exportToFile();
}


// ***********************  worksheet goes korigin  ***************************


void Worksheet::setTable (Table* ta)
{
  int i;

  // first delete old formula entries
  for (i=0; i<T->width(); i++)
    {
      delete formulaData[i];
    }

  // storing the old table name
  QString oldName = T->name ();
  QString newName = ta->name ();
  
  // getting rid of the old table object
  delete T;

  // now inserting the new one and make a redraw
  T = ta;

  //
  // check for the correct worksheet name ( no double occurances allowed )
  //

  // this is necessary because changeName searches for the old tablename to
  // find the correct list entry to change
  T->setName (oldName);
  changeName (newName);

  setCaption (T->name ());

  setMaximumSize (T->width()*CELLWIDTH+FIRSTCELLWIDTH+1+16, 
		    T->height()*CELLHEIGHT+FIRSTCELLHEIGHT+16);

  //
  // update the entries for the formula interpreter
  //
  for (i=0; i<T->width(); i++)
    {
      formulaData[i] = new fiData;
      formulaData[i]->formula = QString("");
      formulaData[i]->constants = QString("");
      formulaData[i]->min = 1;
      formulaData[i]->max = T->height ();
    }
    
  Tdata->resizeTableData (T->height(), T->width());
  Thead->resizeTableHead (T->width());
  TfiCol->resizeTableFirstColumn (T->height());

  resetColumnUsage ();

  repaint ();

  //
  // toplevel should be updated
  //
  emit (updateDescription ());
}


QPopupMenu* Worksheet::getMenu (QPopupMenu* predefined)
  {
	QPopupMenu* menu;
	if (predefined) {
	  menu = predefined;
	  menu->clear();
	} else {
	  menu = new QPopupMenu();
	}
    menu->insertItem ("Information", this, 
		      SLOT (showWorksheetInfoWidget()));
    menu->insertSeparator ();
    menu->insertItem ("Append new Columns", this, 
		      SLOT (showAppendColumnWidget()));
    menu->insertItem ("Append new Rows", this,SLOT (showInsertRowWidget()));
    menu->insertSeparator ();
    menu->insertItem ("Goto Row", this, SLOT (showGotoRowWidget ()));
    menu->insertItem ("Goto Column", this, 
			     SLOT (showGotoColumnWidget ()) );
    menu->insertSeparator ();
    menu->insertItem ("Insert Column", insertPop);
    menu->insertItem ("Delete Column", this, SLOT (showDeleteColumn()));
    menu->insertSeparator ();
    menu->insertItem ("Insert Row", this, SLOT (showInsertRowWidget ()));
    menu->insertItem ("Delete Row", this, SLOT (showDeleteRow ()));
    return menu;
  }


QPopupMenu* Worksheet::getEditMenu (QPopupMenu* predefined)
  {
	QPopupMenu* editmenu;
	if (predefined) {
	  editmenu = predefined;
	  editmenu->clear();
	} else {
	  editmenu = new QPopupMenu ();
	}
    editmenu->insertItem ( "Cut", this, SLOT (cut()) );
    editmenu->insertItem ( "Copy", this, SLOT (copy()) );
    editmenu->insertItem ( "Paste", this, SLOT (paste()) );
    editmenu->insertSeparator ();
    editmenu->insertItem ( "Select all", this, SLOT (selectAll()) );
    return editmenu;
  }


const char* Worksheet::getDescription ()
  {
    static char buffer [255];

    sprintf(buffer,"Worksheet %s:  %i columns, %i rows",(const char*)T->name(), 
	    T->width(), T->height());

    return buffer;
  }


TreeItem* Worksheet::treeitem ()
{
  if (the_treeitem == 0) {
	the_treeitem = new TreeItem();
	the_treeitem->setObject(this);
	the_treeitem->setText(getDescription());
	the_treeitem->setPixmap(getSymbol());
  }
  return the_treeitem;
}


QPixmap* Worksheet::getSymbol ()
  {
    static QPixmap activeIcon = 
	  KApplication::getKApplication()->getIconLoader()->loadIcon(ACTIVE_WORKSHEET);
    static QPixmap inactiveIcon =
	  KApplication::getKApplication()->getIconLoader()->loadIcon(INACTIVE_WORKSHEET);

    if (activeWS == this) {
	  //cout << "icon: " << T->name().data() << " is active." << endl;
      return &activeIcon;
    } else {
	  //cout << "icon: " << T->name().data() << " is inactive." << endl;
      return &inactiveIcon;
	}
  }


Column* Worksheet::getSelected ()
  {
    int i, j;
	static Column IDs [1024];
	for (i=0; i<1024; i++) IDs[i] = Column(Column::columnEmpty);

    // return a NULL pointer if no plotpage there
    if (activePlot == 0) 
      {
	QMessageBox::warning (0, "Warning", "No active plot available"\
			      "\nto plot data in...");
	return (0);
      }

    // return with NULL if nothing selected
    QArray<int> a = high->getSelectedColumns ();

    if (a.size () == 0) 
      {
	QMessageBox::warning (0, "Warning", "No columns selected in "\
			      "active Worksheet!");
	return (0);
      }

	//IDs = 0;
	// WARNING: This has to be worked out!
	// One cannot create a Column instance!
	//
    //IDs = new ColumnID [activePlot->paramCount()];
    // initialize the empty IDs array will be done by the contructor 
    // automatically
    
    QString* iter;

    for (i=0; i<activePlot->paramCount(); i++)
      {
	cout << "Search for " << activePlot->paramName (i) << endl;
	//
	// first go through the marked area and take all selected columns 
	// available
	//
	for (j=0; j < int(a.size()); j++)
	  {
	    if ( usage.at(a[0]+j)->copy() == QString(activePlot->paramName(i)) )
	      {
		IDs[i] = ( T->column ( usage.at() ) );
		cout << "Found in highlighted area" << endl;
		break;
	      }
	  }

	//
	// then watch the rest and only fill the fields which are not given yet
	// return -1 if no column is available for the topic.
	//
	for (iter=usage.first(); iter!=0; iter=usage.next())
	  {
	    if ( iter->copy() == QString(activePlot->paramName(i)) ) 
	      {
		if (IDs[i].type() == Column::columnEmpty)       
		  // nothing found for this parameter
		  {
		    cout << "Found in whole worksheet" <<  endl;
		    IDs[i] = ( T->column ( usage.at() ) );
		    break;
		  }
	      }
	  }
      }

    return (IDs);
  }


// ***************************  formula data  ********************************


fiData* Worksheet::readFormulaData ()
  {
    return (formulaData[curCol]);
  }


void Worksheet::writeFormulaData (fiData* fd)
  {
    formulaData[curCol]->formula = fd->formula;
    formulaData[curCol]->constants = fd->constants;
    formulaData[curCol]->min = fd->min;
    formulaData[curCol]->max = fd->max;
  }


// *************************  page jumping  **********************************


void Worksheet::PgUp ()
  {
    Tdata->scrollUp ();
  }


void Worksheet::PgDown ()
  {
    Tdata->scrollDown ();
  }


// **************************  cut'n paste  **********************************


void Worksheet::paste ()
  {
    copyFromClipboard ();
    Tdata->repaint ();
  }


void Worksheet::cut ()
  {
    int col, row;

    copyToClipboard ();

    for (col=high->getLeftX(); col<=high->getRightX(); col++)
      for (row=high->getUpperY(); row<=high->getLowerY(); row++)
	{
	  T->setCell (col, row, "");
	}
    
    hideHighlighted ();
  }



void Worksheet::copy ()
{
  //
  // copy to clipboard and update the table
  //
  
  copyToClipboard ();
}


void Worksheet::selectAll ()
{
  high->setMouseStartPos (QPoint (0,0), "TData");
  high->setMouseEndPos (QPoint (T->width(), T->height()) );

  // get rid of the lineedit
  Tdata->setFocus (FALSE);

  repaint ();

  if (AUTOCOPY) copyToClipboard ();
}


// ***************************************************************************


void Worksheet::copyToClipboard ()
  {
    int col, row;
    QString text;
    
    for (row=high->getUpperY(); row <= high->getLowerY(); row++)
      {
	for (col=high->getLeftX(); col<=high->getRightX(); col++)
	  {
	    text += T->cell (col, row);
	    text += "\t";
	  }
	text += "\n";
      }

    if (text.length() !=0)
      KApplication::clipboard()->setText ( (const char*)text );
  }


void Worksheet::copyFromClipboard ()
  {
    QString text = QString(KApplication::clipboard()->text());
    int i, newline, col=curCol, row=curRow;

    while ( ((newline = text.find ('\n', 0)) > 0) )
      {
	// find index of \t
	i = text.find ('\t', 0);

	// rewrite Table T;
	T->setCell ( col, row, text.left (i) );
	
	// go to the next column
	col++;

	// cut out the rest text
	text = text.right (text.length()-i-1);
	newline = text.find ('\n', 0);

	if (newline == 0) 
	  {
	    // cut out the \n
	    text = text.right (text.length()-1);

	    // go back to the first column and the next row
	    col = curCol;
	    row++;
	  }
      }
  }


// ***************************************************************************

void Worksheet::showNormalizeColumn ()
  {
    Tdata->showCurrentColumnGrey ();

    int i;

    if ( normColW == 0 )
      {
	normColW = new normalizeColumnWidget (curCol, this);
	i = normColW->exec ();

	delete normColW;
	normColW = 0;
      }

    Tdata->showCurrentColumnNormal ();
  }


void Worksheet::showCalculateWidget ()
  {
    Tdata->showCurrentColumnGrey ();

    int i;

    if ( calcW == 0 )
      {
	calcW = new calculateWidget (curCol, T, this);
	i = calcW->exec ();

	delete calcW;
	calcW = 0;
	emit (dataChanged ());
      }

    Tdata->showCurrentColumnNormal ();
  }


void Worksheet::showClearWorksheet ()
  {
    int col, row;
    QString s;

    int cancel = QMessageBox::warning (0, "Warning", 
	       "You are going to delete all data in this table.\n\nGo ahead?",
	       "Yes", "No", 0, 1);

    if (cancel == 0)       // what means: no cancel of deleting
      {
	for (col=0; col<T->width(); col++)
	  {
	    formulaData[col]->formula = "";
	    formulaData[col]->constants = "";

	    // set the columns titles back to AA, AB, ...
	    s = "";
	    s += 'A' + (col / 26);
	    s += 'A' + (col % 26);
	    T->setTitle ( col, (const char*)s);

	    for (row=0; row<T->height(); row++)
	      {
		T->setCell (col, row, "");
	      }
	    usage.at(col)->QString ("y");
	  } 
	
	usage.at(0)->QString ("x");

	// here reset the column usage

	// show all highlighing
	hideHighlighted ();

	// see whats happening ...
	repaint ();
      }
  }


// ****************************************************************************


void Worksheet::hideHighlighted ()
  {
    if ( high->isHighlighted () == FALSE ) return;
    
    int i,j;
    char who [30];

    int lux = high->getLeftX ();
    int luy = high->getUpperY ();
    int rlx = high->getRightX ();
    int rly = high->getLowerY ();
    strcpy (who, high->whoHasHighlighted ());

    high->setNoHighlight ();

    for (i=lux; i<=rlx; i++)
      for (j=luy; j<=rly; j++)
	Tdata->update (j,i);

    if ( strcmp (who, "Thead") == 0 )
      {
	for (i=lux; i<=rlx; i++)
	  Thead->update (i);
      }
    else if ( strcmp (who, "TfiCol") == 0 )
      {
	for (i=luy; i<=rly; i++)
	  TfiCol->update (i);
      }
  }


void Worksheet::setCellContent (int row, int col, char* content)
  {
    T->setCell (col, row, content);
  }


const char* Worksheet::getCellContent (int row, int col)
  {
    return T->cell (col, row);
  }


void Worksheet::showColStatWidget ()
  {
    Tdata->showCurrentColumnGrey ();

    // this will be interesting later, if we use non modal widgets
    if (colStatW != 0) return;

    colStatW = new columnStatWidget (curCol, this);
    
    colStatW->exec ();

    delete colStatW; 
    colStatW = 0;

    Tdata->showCurrentColumnNormal ();
  }


void Worksheet::showRowStatWidget ()
  {
    Tdata->showCurrentRowGrey (); 

    // this will be interesting later, if we use non modal widgets
    if (rowStatW != 0) return;

    rowStatW = new rowStatWidget (curRow, this);
    
    rowStatW->exec ();

    delete rowStatW; 
    rowStatW = 0;

    Tdata->showCurrentRowNormal ();
  }


void Worksheet::showChColName ()
  {
    Tdata->showCurrentColumnGrey ();

    int i;
    
    if ( chColName == 0 )
      {
	chColName = new columnTitleWidget (curCol, this);
	
	// the next line is tricky: start a modal dialog and get the value
	// of the result back. 0 means "reject", 1 means "ok, do something"
	i = chColName->exec ();

	if ( i == 1 ) 
	  {
	    //
	    // check the title, only allowed once
	    //
	    if (isColumnNameGiven(chColName->getLineEditStr ()) == FALSE)
	      T->setTitle (curCol, chColName->getLineEditStr ());
	    else
	      {
		if (strcmp ((const char*)T->title (curCol), 
			    chColName->getLineEditStr ())==0);
		else QMessageBox::warning (0, "Change Name", 
				   "No two columns with\nsame title allowed!");
	      }
	    Thead->update (curCol); 
	  }

	delete chColName;
	chColName = 0;           // do it for initialization, this is not
      }                          // really necessary cause it's a modal widget

    Tdata->showCurrentColumnNormal ();
  }


void Worksheet::showInsertData ()
  {
    showInsertColumnWidget (insertColumnWidget::Data);
  }


void Worksheet::showInsertLabel ()
  {
    showInsertColumnWidget (insertColumnWidget::Label);
  }


void Worksheet::showAppendColumnWidget ()
  {
    int i, n, t;
    
    if ( insColW == 0 )
      {
	insColW = new insertColumnWidget (insertColumnWidget::Data, 
					  this, "Append");
	
	// the next line is tricky: start a modal dialog and get the value
	// of the result back. 0 means "reject", 1 means "ok, do something"
	i = insColW->exec ();
	
	if ( i == 1 )
	  {
	    n = insColW->getNumberToInsert ();
	    t = insColW->getTypeToInsert ();
	    
	    // here, we get the new columns at the total right
	    insertColumn (n, t, T->width());
	    
	    repaint ();
	  }
	
	delete insColW;
	insColW = 0;           // do it for initialization, this is not
      }                        // really necessary cause it's a modal widget
  }


bool Worksheet::isColumnNameGiven (char* name)
  {
    int i;

    for (i=0; i<T->width(); i++)
      {
	if (strcmp (name, T->title (i)) == 0) 
	  {
	    // they are equal
	    return (TRUE);
	  }
      }
    return (FALSE);
  }


char* Worksheet::getNewColumnTitle ()
  {
    // find tableheadline which is not yet given
    int versuch=0;
    static char s[50];
    char c;

    do
      {
	// generate new name
	strcpy (s, "");
	c = 'A' + (versuch/26);
	strncat (s, &c, 1);
	c = 'A' + (versuch%26);
	strncat (s, &c, 1);

	versuch++;
      }
    while ( isColumnNameGiven (s) == TRUE );

    return (s);    
  }


// when calculating the position: remember we start counting at "0"

void Worksheet::insertColumn (int n, int type, int position)
  {
    int i, j;

    // if position >> numCols, set it to a nice value
    // this is the case when this function is called to insert columns
    // at the end of the table
    if (position > T->width()+1) position = T->width()+1;

    for (i=T->width()-1; i>=position; i--)
      {
	formulaData[i+n] = formulaData[i];
      }
    
    // get new memory by Mr. M
    for (i=0; i<n; i++)
      {
	if (type == 1) 
	  T->insertColumn (i+position, Column(Column::columnDouble));
	if (type == 2) 
	  T->insertColumn (i+position, Column(Column::columnString));

	usage.insert(position, new QString ("y"));

	formulaData[i+position] = new fiData;
	formulaData[i+position]->formula = "";
	formulaData[i+position]->constants = "";
	formulaData[i+position]->min = 1;
	formulaData[i+position]->max = T->height();
      }

    // find n tableheadlines which are not yet given
    for (j=0; j<n; j++) T->setTitle(j+position, getNewColumnTitle () );

    // reset the maximum window position
    setMaximumSize (T->width()*CELLWIDTH+FIRSTCELLWIDTH+1+16, 
		    T->height()*CELLHEIGHT+FIRSTCELLHEIGHT+16);

    Tdata->resizeTableData (T->height(), T->width());
    Thead->resizeTableHead (T->width());

    repaint ();
  }


void Worksheet::showInsertColumnWidget (int type)
  {
    Tdata->showCurrentColumnGrey ();

    int i, n, t;
    
    if ( insColW == 0 )
      {
	insColW = new insertColumnWidget (type, this, "Insert");
	
	// the next line is tricky: start a modal dialog and get the value
	// of the result back. 0 means "reject", 1 means "ok, do something"
	i = insColW->exec ();

	if ( i == 1 )
	  {
	    n = insColW->getNumberToInsert ();
	    t = insColW->getTypeToInsert ();
	    
	    // here, we get the new columns
	    insertColumn (n, t, curCol);

	    repaint ();
	  }

	delete insColW;
	insColW = 0;           // do it for initialization, this is not
      }                        // really necessary cause it's a modal widget

    Tdata->showCurrentColumnNormal ();
  }


void Worksheet::showInsertRowWidget ()
  {
    Tdata->showCurrentRowGrey ();

    int i;

    if ( insRowW == 0 )
      {
	insRowW = new insertRowWidget (this);
	
	// the next line is tricky: start a modal dialog and get the value
	// of the result back. 0 means "reject", 1 means "ok, do something"
	i = insRowW->exec ();

	if ( i == 1 )
	  {
	    cout << curRow << endl;
	    for (i=0; i<insRowW->getNumberToInsert(); i++)
	      {
		T->insertRow (curRow);
	      }
	    
	    Tdata->resizeTableData (T->height(), T->width());
	    TfiCol->resizeTableFirstColumn (T->height());

	    setMaximumSize (T->width()*CELLWIDTH+FIRSTCELLWIDTH+1+16, 
			    T->height()*CELLHEIGHT+FIRSTCELLHEIGHT+16);

	    repaint ();
	  }

	delete insRowW;
	insRowW = 0;           // do it for initialization, this is not
      }                        // really necessary cause it's a modal widget

    Tdata->showCurrentRowNormal ();
  }


void Worksheet::showDeleteColumn ()
  {
    Tdata->showCurrentColumnGrey ();

    int i;
    int result = QMessageBox::warning (0, "Delete Column", 
      "You are attempting to delete this Column!\n\n Do you want to continue?",
				       "Yes", "No", 0, 1);

    // here go on deleting
    if (result == 0)
      {
	if (T->width() <= 1) 
	  {
	    cout << "At least one column is necessary for a table" << endl;
	    return;
	  }	

	// delete it from Mr. M
	T->deleteColumn (curCol);

	// delete from usage list
	usage.remove (curCol);

	// important thing
	delete formulaData[curCol];

	// shift everything important
	for (i=curCol; i<T->width(); i++)
	  {
	    formulaData[i] = formulaData[i+1];
	  }

	if (curCol == T->width()+1) curCol--;

	// re-adjust the maximum widget size
	setMaximumSize (T->width()*CELLWIDTH+FIRSTCELLWIDTH+1+16, 
			T->height()*CELLHEIGHT+FIRSTCELLHEIGHT+16);

	// resize with new number of columns
        Tdata->resizeTableData (T->height(), T->width());
	Thead->resizeTableHead (T->width());
	
	// they should repaint to activate
	repaint ();
      }

    Tdata->showCurrentColumnNormal ();
  }


void Worksheet::showDeleteRow ()
  {
    Tdata->showCurrentRowGrey ();

    int i, n;
    int effectiveDeleted=0;

    if (deleteRowW == 0)
      {
	deleteRowW = new deleteRowWidget (curRow, this);

	i = deleteRowW->exec ();

	// work it out if necessary
	if (i == 1)
	  {
	    n = deleteRowW->getLastToDelete ();

	    for (i=curRow; i<n; i++)
	      {
		if (i >= T->height()) break;
		
		effectiveDeleted++;      // have I really deleted anything
		T->deleteRow (curRow);
	      }
	    cout << "Deleted:" << effectiveDeleted << endl;
	      
	    // curRow koennte auch auf der letzten Zeile sitzen
	    if (curRow >= T->height()) curRow = T->height()-1;

	    // the widget should also be informed - before repaint 
	    Tdata->resizeTableData (T->height(), T->width());
	    TfiCol->resizeTableFirstColumn (T->height());
	    
	    setMaximumSize (T->width()*CELLWIDTH+FIRSTCELLWIDTH+1+16, 
			    T->height()*CELLHEIGHT+FIRSTCELLHEIGHT+16);

	    repaint ();
	  }

	delete deleteRowW;
	deleteRowW = 0;
      }

    Tdata->showCurrentRowNormal ();
  }


void Worksheet::showWorksheetInfoWidget ()
  {
    int i;

    if ( ws_info == 0 )
      {
	ws_info = new WS_info (0, 0, T->name(), (const char*)notes, 
			       T->width(), T->height());
	
	// the next line is tricky: start a modal dialog and get the value
	// of the result back. 0 means "reject", 1 means "ok, do something"
	i = ws_info->exec ();

	if ( i == 1 )
	  {
	    //
	    // let the worksheet control the given names
	    //
	    if (strlen (ws_info->getNewName ()) > 0)
	      {
		changeName (ws_info->getNewName ());
		setCaption (T->name ());

		emit (updateDescription());
	      }
	    
	    // the worksheets notes:
	    notes = ws_info->getNewNotes ();
	  }

	delete ws_info;
	ws_info = 0;           // do it for initialization, this is not
      }                        // really necessary cause it's a modal widget
  }


void Worksheet::showGotoRowWidget ()
  {
    int i;
    gotoW = new gotoWidget (this, "Row");

    i = gotoW->exec ();

    if ( i == 1 ) 
      {
	Tdata->changeTopCell ( atoi ( gotoW->getGoto() ) -1);
	TfiCol->changeTopCell ( atoi ( gotoW->getGoto() ) -1);
      }

    delete gotoW;
  }


void Worksheet::showGotoColumnWidget ()
  {
    int i;

    gotoW = new gotoWidget (this, "Column");
    
    i = gotoW->exec ();
    
    if ( i == 1 ) 
      {
	Tdata->changeLeftCell ( T->findColumn ( gotoW->getGoto() ) );
	Thead->changeLeftCell ( T->findColumn ( gotoW->getGoto() ) );
      }

    delete gotoW;
  }


void Worksheet::showColumnPopup (QPoint p)
  {
    QRect hilf = geometry ();

    // the different column typed show different popups...
    cout << "showColumnPopup type " << T->type (curCol) << endl;

    if (T->type(curCol) == Column::columnDouble)
      dataColPop->popup ( p + hilf.topLeft () );
    else if (T->type(curCol) == Column::columnString)
      labelColPop->popup ( p + hilf.topLeft () );
  }


void Worksheet::showRowPopup (QPoint p)
  {
    QRect hilf = geometry ();
    rowPop->popup ( p + hilf.topLeft () );
  }


void Worksheet::mousePressEvent (QMouseEvent *e)
  {
    // emit a signal to get the active WS if mousepress inside
    if (activeWS != this)
      {
	emit (activeWSChanged (this));
	cout << "activeWSChanged" << endl;
      }

    // define the left upper cell in a temp variable
    QRect a (0,0,FIRSTCELLWIDTH,FIRSTCELLHEIGHT);
    
    //    hideHighlighted ();

    // right mousebutton inside left upper cell opens popup menu
    if ( (a.contains (e->pos ()) == TRUE) && (e->button () == RightButton) )
      {
	QRect hilf = geometry ();
	
	// which buttons should be de-activated?
	if (high->isHighlighted() == FALSE) 
	  {
	    mainPop->setItemEnabled (mainPop->idAt(11), FALSE);
	    mainPop->setItemEnabled (mainPop->idAt(12), FALSE);
	  }
	else 
	  {
	    mainPop->setItemEnabled (mainPop->idAt(11), TRUE);
	    mainPop->setItemEnabled (mainPop->idAt(12), TRUE);
	  }
	
	if (Tdata->hasFocus() == TRUE)
	  mainPop->setItemEnabled (mainPop->idAt(13), TRUE);
	else mainPop->setItemEnabled (mainPop->idAt(13), FALSE);

	mainPop->popup ( e->pos () + hilf.topLeft () );
      }
  }


void Worksheet::paintEvent(QPaintEvent* )
  {
    QPainter p;

    p.begin (this);

    p.setPen (NoPen);
    p.setBrush (KApplication::getKApplication()->backgroundColor);  
    p.drawRect (1,1,FIRSTCELLWIDTH-1,FIRSTCELLHEIGHT-1);    // links oben Eck
    p.drawRect (width()-16, 1, width(), FIRSTCELLHEIGHT-1);
    p.drawRect (1, height()-16, FIRSTCELLWIDTH-1, height());

    p.setBrush (NoBrush);
    p.setPen (SolidLine);
    p.drawLine (0,FIRSTCELLHEIGHT-1,FIRSTCELLWIDTH,FIRSTCELLHEIGHT-1);
    p.drawLine (FIRSTCELLWIDTH-1,0,FIRSTCELLWIDTH-1,FIRSTCELLHEIGHT-1);   
    p.drawLine (width()-18, FIRSTCELLHEIGHT-1, width(), FIRSTCELLHEIGHT-1);
    p.drawLine (FIRSTCELLWIDTH-1, height()-18, FIRSTCELLWIDTH-1, height());
    
    p.end ();
  }


Worksheet::~Worksheet ()
  {
    QString* iter;

	if (activeWS == this) activeWS = 0;

    for (iter=Worksheet::givenWSNames.first(); iter!=0;
	 iter=Worksheet::givenWSNames.next())
      {
	if (*iter == T->name()) 
	  {
	    Worksheet::givenWSNames.remove ();
	  }
      }

    delete the_treeitem;

    delete Tdata;
    delete Thead;
    delete TfiCol;
  }


void Worksheet::repaint ()
  {
    QWidget::repaint ();

    Tdata->repaint ();
    Thead->repaint ();
    TfiCol->repaint ();
  }


void Worksheet::resizeEvent (QResizeEvent*)
  {
    Tdata->setGeometry (FIRSTCELLWIDTH, FIRSTCELLHEIGHT, 
			width()-FIRSTCELLWIDTH, height()-FIRSTCELLHEIGHT);
    Thead->setGeometry (FIRSTCELLWIDTH, 0, width()-FIRSTCELLWIDTH-16, 
			FIRSTCELLHEIGHT);
    TfiCol->setGeometry (0, FIRSTCELLHEIGHT, FIRSTCELLWIDTH, 
			 height ()-16-FIRSTCELLHEIGHT);
  }


void Worksheet::mouseMoveEvent (QMouseEvent* )
  {
    cout << "I got a mouseMoveEvent while a button was pressed down" << endl;
  }

























