#define XSIZECM 24		/* at 120 DPI  */
#define YSIZECM 24		/* at 72 DPI */
#define NXBITS 200
#define NYBITS 200
#include "bitmap.h"
extern char outbitname[];
extern int fittobit;
dvitype(void)
{
	fittobit = true;
	printf("Adding TIFF, Include the EPF file into WordPerfect.");
	strlwr(outbitname);
	if (strlen(outbitname)==0) {
		printf("You must give the name of the gle file.\n");
		abort();
	}
	if (strstr(outbitname,".")!=0) {
	    * strchr(outbitname,'.') = 0;
	}
	strcat(outbitname,".epf");
}
/* tiff stuff starts here */

int32 sa(int32 a);
int32 ss(char *s);
int32 sw(int x);
int32 sl(int32 x);
int32 read_eps(char *fname,FILE *tf);
int sendmem(char *s, int32 j);
int setl(int32 p, int32 x);
int setw(int32 p, int x);

int32 tcnt; /* current byte position */
extern FILE *outbit;
FILE *tf;
extern int dev_nops;
int addeps=true;
int32 tstart;
bitmap_print()
{
	/* 1=byte, 2=ascii, 3=short, 4=int32, 5=rational */
	char fname[80];
	int32 strip1,entrycount,stripoffsets,stripbcounts,ifd;
	int32 datep,datelen,namep,namelen,i,j;
	int32 h_ps,h_pslen,h_tiff,h_tifflen;

	if (dev_nops) addeps = false;
	tf = outbit; /* output file handle */

	if (addeps) {
	    sw(0xd0c5); sw(0xc6d3);
	    h_ps = sl(0);
	    h_pslen = sl(0);
	    sl(0); sl(0);
	    h_tiff = sl(0);
	    h_tifflen = sl(0);
	    sw(0xffff);

	    setl(h_ps,sa(tcnt));
	    i = tcnt;
	    tcnt += read_eps(outbitname,tf);
	    setl(h_pslen,tcnt-i);
	}


	tstart = sw(0x4949); /* byte order  4d 4d */
	sw(0x002a);
	ifd = sl(0x0000);
	entrycount = sw(0);
	setl(ifd,sa(entrycount));
	sw(0xff); sw(3); sl(1); sw(1);  sw(0);		/* subfiletype */
	sw(0x100); sw(3); sl(1); sl(nxbits); 	/* image width */
	sw(0x101); sw(3); sl(1); sl(nybits);      	/* image length */
	sw(0x102); sw(3); sl(1); sw(1); sw(0);  /* bits per sample */
	sw(0x103); sw(3); sl(1); sw(1); sw(0);	/* no compression */
	sw(0x106); sw(3); sl(1); sw(1); sw(0);  /* black and white */
	sw(0x111); sw(4); sl(1); stripoffsets = sl(0); /* offsets to image data */
	sw(0x11c); sw(3); sl(1); sw(1); sw(0); /* planar config */
	sw(0x131); sw(2); namelen = sl(1); namep = sl(0); /* Name  */
	sl(0); /* end of table  */
	setw(entrycount,9);
	strip1 = tcnt;
	send_image();
	setl(stripoffsets,sa(strip1));

	namelen = strlen("GLE Tiff output.");
	setl(namep,sa(ss("GLE Tiff output.")));

	if (addeps) {
		setl(h_tiff,tstart);
		setl(h_tifflen,tcnt-tstart);
	}

	fclose(tf);

}
unsigned char swapbit[256];
send_image()
{
	int y;
	unsigned char swapnib[16]={0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15};
	unsigned char *o,c;
	int i,n1,n2;

	printf("Writing out TIFF image \n");
	for (i=0;i<256;i++) {
		n1 = i & 0xf;
		n2 = (i >> 4) & 0xf;
		swapbit[i] = swapnib[n2] | (swapnib[n1] << 4);
	}


	for (y=nybits-1 ; y>=0 ; y-=1)
		print_row(y);
}
print_row(int y)
{
	unsigned char savechar,temp;
	static unsigned char out_buff[NXBITS+10];
	unsigned int r,i,j,newy,x,z;
	unsigned char *line;
	out_buff[0] = 0;
	line = bitmap_line(y);
	for (i=0; i<nxbits/8; i++) {
		out_buff[i] = swapbit[line[i]];
	}

	sendmem(out_buff,nxbits/8);
}


int32 sa(int32 a)
{
	return a-tstart;
}
int32 sw(int x)
{
	fwrite(&x,2,1,tf);
	tcnt += 2;
	return tcnt-2;
}
int32 ss(char *s)
{
	int i;

	i = strlen(s)+1;
	if (i&1 == 1) i++;
	fwrite(s,1,i,tf);
	tcnt += i;
	return tcnt-i;
}
sendmem(char *s, int32 j)
{
	fwrite(s,1,j,tf);
	tcnt += j;
}
int32 sl(int32 x)
{
	fwrite(&x,4,1,tf);
	tcnt += 4;
	return tcnt-4;
}
setl(int32 p, int32 x)
{
	if (fseek(tf,p,SEEK_SET)!=0)  printf("Seekl failed, %ld %ld\n",p,tcnt);
	fwrite(&x,4,1,tf);
	if (fseek(tf,tcnt,SEEK_SET)!=0) printf("Seekl eof failed, %ld \n",p);
}
setw(int32 p, int x)
{
	if (fseek(tf,p,SEEK_SET)!=0) printf("Seekw failed, %ld  %ld\n",p,tcnt);
	fwrite(&x,2,1,tf);
	if (fseek(tf,tcnt,SEEK_SET)!=0) printf("Seekw eof failed, %ld \n",p);
}

int32 read_eps(char *fname,FILE *tf)
{
	FILE *eps;
	static char buff[1002];
	char *s;
	int32 tot=0;
	int n;

	strcpy(buff,fname);
	s = strchr(buff,'.');
	if (s!=NULL) *s = 0;
	strcat(buff,".eps");

#ifdef ultrix
	eps = fopen(buff,"r");
#else
	eps = fopen(buff,"rb");
#endif
	if (eps==NULL) {
		printf("Unable to open {%s}, you must PSGLE /EPS first\n",buff);\
		abort();
	}

	for (;!feof(eps);) {
	  n = fread(buff,1,1000,eps);
	  if (n>0) {
		fwrite(buff,1,n,tf);
		tot += n;
	  }
	}
	buff[0] = 13; buff[1] = 10; buff[2] = 0;
	if (tot&1 == 1) {fwrite(" ",1,1,tf); tot++;}
	fwrite(buff,1,2,tf); tot+=2;
	return tot;
}


