/*--------------------------------------------------------------*/
/*      Bitmap Driver 1.0 (VAX C, TURBO  C) , for GLE V3.0      */
/*--------------------------------------------------------------*/
/* This version writes the PATH to a temporary file which can
/* then be read by a bitmap driver (which has more memory available) */
/*---------------------------------------------------------------------------*/
#include "all.h"
#include <math.h>
#include "core.h"
#include "mygraph.h"
#include "mydev.h"
#ifndef __TURBOC__
#define huge
#else
#include <alloc.h>
#endif
extern int dev_fill,dev_font;
extern int gunit;
extern struct gmodel g;
/*---------------------------------------------------------------------------*/
#define pi 3.141592653
#define true (!false)
#define SOLID_LINE 1
#define DASHED_LINE 2
#define BLACKANDWHITE 1
#define false 0
#define dbg if ((gle_debug & 64)>0)
extern int gle_debug;
int getch(void);
int kbhit(void);


int path_newpath(void);
int path_lwidth(float x);
int path_setcolor(float x);
int path_setcolori(int x);
int path_setfilli(int x);
int path_stroke(void);
int path_fill(void);
int path_setfill(float x);
int path_lstyle(int x);
int path_dline(float x,float y);
int path_size(float x,float y);
int path_row(float x1, float y1, float x2, float y2);
int path_box(float x1, float y1, float x2, float y2);
int path_alloc(void);
int path_move(float x1, float y1);
int path_line(float x1, float y1);
int flatten_bezier(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3);
int path_closepath(void);
int bitmap_print(void);
int bitmap_free(void);
int bitmap_alloc(void);
int bitmap_paint(int row, int x1, int x2);
int intline(int  x1, int  y1, int  x2, int  y2);


/*---------------------------------------------------------------------------*/

#define scx(v) ( (v) )
#define scy(v) ( ((v)  ))
#define rx(v) ( ((v) ))
#define ry(v) ( ((v) ))


int d_graphmode;
int d_fillstyle=1,d_fillcolor;
int d_lstyle,d_lwidth,d_color;
int d_maxy;
/*---------------------------------------------------------------------------*/
/*   Path variables for bitmap */
typedef union {int32 l; float f;} longfloat;
longfloat *path;
int npath;
int npath_alloc;
#include "pathtypes.h"
/* -ve is used to indicate up or down */
int row_min,row_max;
static int lastany = true,ffup = 3;
static float ffx= -1,ffy= -1,lastx= -1,lasty= -1,cx= -1,cy= -1;
path_reset()
{
	ffx = -1; ffy = -1; ffup = 3;
	lastany = true;
	lastx = -1; lasty = -1;
	cx = -1; cy = -1;
}
path_newpath(void)
{
	path_alloc();
	path[npath++].l = p_newpath;
}
path_move(float x,float y)
{
	path_alloc();
	path[npath++].l = p_move;
	path[npath++].f = x;
	path[npath++].f = y;
}
path_lwidth(float x)
{
	path_alloc();
	path[npath++].l = p_lwidth;
	path[npath++].f = x;
}
path_setfilli(int x)
{
	path_alloc();
	path[npath++].l = p_setcolori;
	path[npath++].l = x;
}
path_setcolori(int x)
{
	path_alloc();
	path[npath++].l = p_setcolori;
	path[npath++].l = x;
}
path_setcolor(float x)
{
	path_alloc();
	path[npath++].l = p_setcolor;
	path[npath++].f = x;
}
path_stroke(void)
{
	path_alloc();
	path[npath++].l = p_stroke;
}
path_fill(void)
{
	path_alloc();
	path[npath++].l = p_fill;
}
path_setfill(float x)
{
	path_alloc();
	path[npath++].l = p_setfill;
	path[npath++].f = x;
}
path_lstyle(int x)
{
	path_alloc();
	path[npath++].l = p_lstyle;
	path[npath++].l = x;
}
path_dline(float x,float y)
{
	path_alloc();
	path[npath++].l = p_dline;
	path[npath++].f = x;
	path[npath++].f = y;
}
path_size(float x,float y)
{
	path_alloc();
	path[npath++].l = p_size;
	path[npath++].f = x;
	path[npath++].f = y;
}
path_line(float x,float y)
{
	path_alloc();
	path[npath++].l = p_line;
	path[npath++].f = x;
	path[npath++].f = y;
}
path_bezier(float x1, float y1, float x2, float y2,float x3, float y3)
{
	path_alloc();
	path[npath++].l = p_bezier;
	path[npath++].f = x1;   path[npath++].f = y1;
	path[npath++].f = x2;   path[npath++].f = y2;
	path[npath++].f = x3;   path[npath++].f = y3;
}
path_closepath()
{
	path_alloc();
	path[npath++].l = p_closepath;
}
path_box(float x1, float y1, float x2, float y2)
{
	path_move(x1,y1);
	path_line(x2,y1);
	path_line(x2,y2);
	path_line(x1,y2);
	path_closepath();
}
path_alloc(void)
{
	static int npa;
	int32 *a;
	if (npath > 100) path_flush();
	if (npath < (npath_alloc-20)) return;
	npath_alloc = 20 + 2 * npath;
	a = myallocz(npath_alloc*sizeof(int32));
	if (a==NULL) {
		gle_abort("Unable to allocate memory for path \n");
	}
	if (path != NULL) {
		memcpy(a,path,(npa)*sizeof(int32));
		myfree(path);
	}
	npa = npath_alloc;
	path = (longfloat *) a;
}
path_free(void)
{
	if (path==NULL) return;
	myfree(path);
	path = NULL;
	npath = 0;
	npath_alloc = 0;
}

d_devcmd(char *s)
{}
dxy(double x, double y, float *dx, float *dy)
{
	static double fx,fy;
	g_dev(x,y,&fx,&fy);
	*dx = scx(fx);
	*dy = scy(fy);
}
rxy(double x, double y, int *dx, int *dy)
{
	static double fx,fy,zx,zy;
	g_dev(x,y,&fx,&fy);
	g_dev(0.0,0.0,&zx,&zy);
	*dx = (int) ( (fx-zx) );
	*dy = (int) ( (fy-zy) );
}
/*---------------------------------------------------------------------------*/
d_dfont(char *c)
{
	/* only used for the DFONT driver which builds fonts (never used)*/
}
/*---------------------------------------------------------------------------*/
d_message(char *s)
{
	printf("%s\n",s);
}
/*---------------------------------------------------------------------------*/
d_source(char *s)
{
	s=s;
}
/*---------------------------------------------------------------------------*/
d_get_type(char *t)
{
	strcpy(t,"OUTPUT, BITMAP, BLACKANDWHITE, HARDCOPY, FILLPATH");
}
/*---------------------------------------------------------------------------*/
d_set_path(int onoff)
{
}
/*---------------------------------------------------------------------------*/
d_newpath()
{
	path_flush();
	path_newpath();
}
/*---------------------------------------------------------------------------*/
FILE *dout;
path_flush(void)
{
	if (npath>0) fwrite(path,sizeof(int32),npath,dout);
	npath = 0;
}
d_open(double width, double height)
{
	char *outfile;
	outfile = "out.dvi";
#ifdef ultrix
	dout = fopen(outfile,"w");
	if (dout == NULL) gle_abort("Unable to open OUT.DVI epson output file \n");
#else
	dout = fopen(outfile,"wb");
	if (dout == NULL) gle_abort("Unable to open OUT.EP epson output file \n");
#endif
	path_alloc();
	path_size(width,height);
	if (!dev_font) plotter_fonts();
}
/*---------------------------------------------------------------------------*/
d_tidyup()
{
	gprint("AARRRrrrrgg,  Dieing\n");
}
d_close()
{
	g_flush();
	path_flush();
	path_free();
	fclose(dout);
	printf("Now enter one of:\n");
	printf("   DVIEPSON   (to print to a dot matrix printer)\n");
	printf("   DVIEP24    (to print to 24 Pin epson printers)\n");
	printf("   DVILJ      (to print to an HP LaserJet/DeskJet printer)\n");
	printf("   DVILJ300   (same as dvilj but slower with better resolution\n");
	printf("   DVIPJ      (HP Paint Jet, use DVIGLE myfile /FILL \n");
}
/*---------------------------------------------------------------------------*/
d_set_line_cap(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_join(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_miterlimit(double d)
{
	int i=0;
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_width(double w)
{
	float dx,dy,zx,zy;

	dxy(w,w,&dx,&dy);
	dxy(0.0,0.0,&zx,&zy);
	path_lwidth(sqrt(pow(dx-zx,2) + pow(dy-zy,2)));
	path_lwidth(w);
}
/*---------------------------------------------------------------------------*/
d_set_line_styled(double dd)
{}
d_set_line_style(char *s)
{
	d_lstyle = DASHED_LINE;
	if (strcmp(s,"")==0) d_lstyle = SOLID_LINE;
	if (strcmp(s,"1")==0) d_lstyle = SOLID_LINE;
	path_lstyle(d_lstyle);
}
/*---------------------------------------------------------------------------*/
d_fill()
{
	path_fill();
}
/*---------------------------------------------------------------------------*/
d_fill_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;

	path_move( (*wkx)[0], (*wky)[0]);
	for (i=1;i<nwk;i++) {
		path_line( (*wkx)[i], (*wky)[i]);
	}
	d_fill();
}
d_line_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;

	path_move( (*wkx)[0], (*wky)[0]);
	for (i=1;i<nwk;i++) {
		path_line( (*wkx)[i], (*wky)[i]);
	}
	d_stroke();
}
/*---------------------------------------------------------------------------*/
d_stroke()
{
	path_stroke();
}
/*---------------------------------------------------------------------------*/
d_clip()
{
}
/*---------------------------------------------------------------------------*/
d_set_matrix(double newmat[3][3])
{

}
/*---------------------------------------------------------------------------*/
d_move(double zx,double zy)
{
}
/*---------------------------------------------------------------------------*/
d_reverse()     /* reverse the order of stuff in the current path */
{
}
/*---------------------------------------------------------------------------*/
d_closepath()
{
	path_closepath();
}
int bit_line( double x, double y);
/*---------------------------------------------------------------------------*/
d_line(double zx,double zy)
{
	float dx,dy;
	if (g.xinline==false) {
		dxy(g.curx,g.cury,&dx,&dy);
		path_move(dx,dy);
	}
	if (g.inpath==false) {
		dxy(zx,zy,&dx,&dy);
		path_dline(dx,dy);
		return;
	}
	dxy(zx,zy,&dx,&dy);
	path_line(dx,dy);
}


/*---------------------------------------------------------------------------*/
d_clear()
{
	d_lstyle = SOLID_LINE;
	d_lwidth = 1;

}
/*---------------------------------------------------------------------------*/
d_flush()
{
}
/*---------------------------------------------------------------------------*/
d_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
	df_arcto(x1,y1,x2,y2,rrr);
}
/*---------------------------------------------------------------------------*/
d_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	df_arc(r,t1,t2,cx,cy);
}
/*---------------------------------------------------------------------------*/
d_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	/* swap t1 t2*/
	df_arc(r,t2,t1,cx,cy);
}
/*---------------------------------------------------------------------------*/
d_box_fill(dbl x1, dbl y1, dbl x2, dbl y2)
{
	if (dev_fill) {
		path_box(x1,y1,x2,y2);
		d_fill();
		return;
	}
	df_box_fill(x1,y1,x2,y2);
}
d_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2)
{
	df_box_stroke(x1,y1,x2,y2);
}
/*---------------------------------------------------------------------------*/
d_circle_stroke(double zr)
{
	df_circle_stroke(zr);
}
d_circle_fill(double zr)
{
	df_circle_fill(zr);
}
/*---------------------------------------------------------------------------*/
int df_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3);
d_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
	float dx1,dy1,dx2,dy2,dx3,dy3,dx0,dy0;

	if (g.inpath==false) {
		df_bezier(x1,y1,x2,y2,x3,y3);
		return;
	}
	if (g.xinline==false) {
		dxy(g.curx,g.cury,&dx0,&dy0);
		path_move(dx0,dy0);
	}

	dxy(x1,y1,&dx1,&dy1);
	dxy(x2,y2,&dx2,&dy2);
	dxy(x3,y3,&dx3,&dy3);
	path_bezier(dx1,dy1,dx2,dy2,dx3,dy3);
}
/*---------------------------------------------------------------------------*/
d_set_color(int32 f)
{
	int i;
	colortyp  cc;
	cc.l = f;
	path_setcolor(((cc.b[B_R]*3.0/255.0
		+cc.b[B_G]*2.0/255.0+cc.b[B_B]/255.0) / 6));
	path_setcolori(cvt_color_i(f));
}
cvt_color_i(int32 f)
{
	int i;
	colortyp  cc;
	cc.l = f;
	i = 0;
	if (cc.b[B_R]>1 && cc.b[B_G]>1 && cc.b[B_B]>1) i = 10; /* blue */
	if (cc.b[B_R]>60 && cc.b[B_G]>60 && cc.b[B_B]>60) i = 9; /*green*/
	if (cc.b[B_R]>100) i = 1;       /* red */
	if (cc.b[B_G]>100) i = 2;       /* green */
	if (cc.b[B_B]>100) i = 3;       /* blue */
	if (cc.b[B_R]>100 && cc.b[B_G]>100) i = 4; /* yellow */
	if (cc.b[B_G]>100 && cc.b[B_B]>100) i = 5; /* cyan */
	if (cc.b[B_R]>100 && cc.b[B_B]>100) i = 6; /* Magenta */
	if (cc.b[B_R]>100 && cc.b[B_G]>100 && cc.b[B_B]>100) i = 8;  /*red*/
	if (cc.b[B_R]>250 && cc.b[B_G]>250 && cc.b[B_B]>250) i = 7;
	return i;
}
d_set_fill(int32 f)
{
	int i;
	colortyp  cc;
	cc.l = f;
	path_setfill(((cc.b[B_R]*3.0/255.0
		+cc.b[B_G]*2.0/255.0+cc.b[B_B]/255.0) / 6));
	path_setfilli(cvt_color_i(f));
}
/*---------------------------------------------------------------------------*/
d_beginclip()
{
}
d_endclip()
{
}
struct char_data {float wx,wy,x1,y1,x2,y2; };
int font_get_chardata(struct char_data **cd, int ff, int cc);
/*---------------------------------------------------------------------------*/
int safnt;
int simple_char(int cc);
d_char(int font, int cc)
{
	static struct char_data cd;
	static int ix1,ix2,iy1,iy2;
	static int ux,uy;
	char ss[2];

	ss[0] = cc;
	ss[1] = 0;
	if (safnt==0) safnt = pass_font("PLSR");
	if (font_get_encoding(font)>2) {
		my_char(font,cc);
		return;
	}
	my_char(safnt,cc);
}


