/*
gdpc - a program for visualising molecular dynamic simulations  
Copyright (C) 1999 Jonas Frantz   

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* Here the versionnumber of gdpc is set, that will be reported. */
#define GDPCVER "1.25"

/* Define the value of pi */
#define PI 3.1415927

/* Define how large the border around the simulationbox should be,
   if you change this remember to also change it in main.c.        */
#define xborder 15		/* X border */
#define yborder 15		/* Y border */

/* Allocate this many number of structures at a time in the non-xyz
   format reading. */
#define ALLOCTHIS 1000

/* Number of colors to use, dont change this if youre not also 
   changing colors.c.                                          */ 
#define NUMCOLORS 16

/* Define the size of the drawable area without borders */
#define drawXsize 600		/* X-size */
#define drawYsize 600		/* Y-size */

/* Define the minimum interval between timeouts */
#define MININTERVAL 25

/* Define the maximum numbers of different atom types used in animation */
#define MAXTYPES 100

/* Structure to describe the atoms internally. */
struct xyzstruc {
    float xcoord;		/* X-coordinate */
    float ycoord;		/* Y-coordinate */
    float zcoord;		/* Z-coordinate */
    float tcoord;		/* t-coordinate */
    gint  atype;		/* atom type */
    gint  index;		/* index */
};

struct GlobalParams {
gint xcolumn;			/* Which column is the x coordinate */
gint ycolumn;			/* Which column is the y coordinate */
gint zcolumn;			/* Which column is the z coordinate */
gint tcolumn;			/* Which column is the t coordinate */
gint absxsize;			/* Size of drawing area x-wise */
gint absysize;			/* Size of drawing area y-wise */
gint ncolors;			/* Number of colors */
gint colorset;			/* Set of colors to use */
gint mode;			/* Drawing mode */
gint radius;			/* Radius of drawable objects */
gint sort;			/* Method of sorting atoms */
gint vary;			/* Method of varying drawable objectsize */
gint scol;			/* Something */
gint xpress;			/* x coordinate for mousebuttonpress */
gint ypress;			/* y coordinate for mousebuttonpress */
gint oldxc;			/* Old angular correction, x-wise */
gint oldyc;			/* Old angular correction, y-wise */
gint oldzc;			/* Old angular correction, z-wise */
gint oldtc;			/* Old angular correction, t-wise */
gint oldxsize;
gint oldysize;
gint numframe;			/* Number of the frame */
gint interval;			/* Interval in time between frames */
gint numtypes;
float iangle;			/* Angle of view around x */
float jangle;			/* Angle of view around y */
float kangle;			/* Angle of view around z */
float imangle;
float jmangle;
float xmin;			/* Minumum x coordinate */
float xmax;			/* Maximum x coordinate */
float ymin;			/* Minumum y coordinate */
float ymax;			/* Maximum y coordinate */
float zmin;			/* Minumum z coordinate */
float zmax;			/* Maximum z coordinate */
float xmin2;
float xmax2;
float ymin2;
float ymax2;
float zmin2;
float zmax2;
float xc;			/* Angular correction, x-wise */
float yc;			/* Angular correction, y-wise */
float zc;			/* Angular correction, z-wise */
gboolean pausecheck;		/* Is animation on pause ? */
gboolean drawcheck;		/* Are we drawing a frame now ? */
gboolean atEnd;			/* Are we at the end of the animation ? */
gboolean rotated;		/* Is the box rotated from last frame ? */
gboolean setupstop;		/* Is the animation being configured ? */
gboolean whitebg;		/* Do we want a white background ? */
gboolean erase;			/* Do we want to erase the old frame before drawing a new one ? */
gboolean fxyz;			/* Is input in xyz-format ? */
gboolean pressed;		
gboolean dumpnum;		/* Do we want number-of-frame or timestamp on dumped images ? */
gboolean tifjpg;		/* Do we want tifs or jpgs to be dumped ? */
gboolean StartedAlready;	/* Is the animation started ? */
gboolean redrawcheck;
gboolean usetypes;
char fstring[30];
char file[160];			/* Name of input file */
char dumpname[50];		/* Names of dumped images */
};


void StartEverything (struct GlobalParams *params);
void SetupStartOk    (struct GlobalParams *params);
void SetupStartCancel(struct GlobalParams *params);
void SetupRedraw     (struct GlobalParams *params);

void cleardrawable (GtkWidget *widget, GdkPixmap *pixmap, GdkColor *colors,
                   struct GlobalParams *params);

void setupwindow (struct GlobalParams *params);

void rotateatoms (GdkPixmap *pixmap, GdkColor *colors, struct GlobalParams *params);

void mouserotate (GtkWidget *widget, gint xdelta, gint ydelta, struct GlobalParams *params);

void xplusb   (GtkWidget *widget, struct GlobalParams *params);
void yplusb   (GtkWidget *widget, struct GlobalParams *params);
void zplusb   (GtkWidget *widget, struct GlobalParams *params);
void xminusb  (GtkWidget *widget, struct GlobalParams *params);
void yminusb  (GtkWidget *widget, struct GlobalParams *params);
void zminusb  (GtkWidget *widget, struct GlobalParams *params);
void xplus10b (GtkWidget *widget, struct GlobalParams *params);
void yplus10b (GtkWidget *widget, struct GlobalParams *params);
void zplus10b (GtkWidget *widget, struct GlobalParams *params);
void xminus10b(GtkWidget *widget, struct GlobalParams *params);
void yminus10b(GtkWidget *widget, struct GlobalParams *params);
void zminus10b(GtkWidget *widget, struct GlobalParams *params);
void resetob  (GtkWidget *widget, struct GlobalParams *params);

void sortatoms(struct xyzstruc *coords, gint left, gint right, gboolean sort);

void drawrotate(GtkWidget *widget, struct GlobalParams *params);
void resetic();

gint drawnext (struct GlobalParams *params);
gint allocatecolors (GdkColor **colors, gint colorset, gint mode);

gboolean drawatoms(GdkPixmap *pixmap, GdkColor *colors, GtkWidget *widget, FILE *fp,
		   float *atime, struct GlobalParams *params);

gboolean handleargs(int args, char **argv, struct GlobalParams *params);

