/* to define the escape key */
#define XK_MISCELLANY 1

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <asm/errno.h>
#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include <assert.h>
#include <unistd.h>

#define NIL (0)
#define SCROLL 40
#define SCRW 640
#define SCRH 480

int wdt,hgt,clrs;
int strtcol,strtrow,endcol,endrow;
int scrwdt,scrhgt;
int whiteColor,blackColor;
unsigned long red;
Display *dpy;
Window w;
GC gc;
Screen *dfltscr;
Colormap cmap;
XColor scrdef,exctdef;

char *mtx;

/* XDrawLine(dpy, w, gc, y1, z1, y2, z2); */
/* XDrawPoint(dpy, w, gc, x, y); */

void badmagic()
   {
   fprintf(stderr,"Magic number for binary "
      ".ppm file should be P6\n");
   exit(1);
   } /* badmagic */

void badnum()
   {
   fprintf(stderr,"Invalid character: expected number\n");
   exit(1);
   } /* badnum */

void ppmeof()
   {
   fprintf(stderr,"End of file\n");
   exit(1);
   } /* ppmeof */

int getbyte()
   {
   int rdlen;
   unsigned char buf[8];
   rdlen = read(0,buf,1);
   if (rdlen < 0)
      {
      fprintf(stderr,"Error no. %d\n", errno);
      perror("Read error");
      exit(1);
      } /* read err */
   else if (rdlen == 0) return(EOF);
   else return(buf[0]);
   } /* getbyte */

int getnum(num)
int num;
   {
   int ch,tot;
   tot = 0;
   if (num >= '0' && num <= '9')
      tot = num - '0';
   else badnum();
   while ((ch = getbyte()) >= '0' && ch <= '9')
      {
      tot = (tot * 10) + (ch - '0');
      } /* for each digit */
   if (ch == EOF) ppmeof();
   else if (ch == '\t' || ch == '\n'
      || ch == ' ') return(tot);
   else badnum();
   } /* getnum */

void putwin()
   {
   int x,y,currclr;
   char *p;
   p = mtx;
   XSetForeground(dpy,gc,blackColor);
   currclr = 1;
   endcol = strtcol + SCRW;
   endrow = strtrow + SCRH;
   for (y=0;y<hgt;y++)
      {
      for (x=0;x<wdt;x++)
         {
         if (y < strtrow
            || y >= endrow
            || x < strtcol
            || x >= endcol)
            {
            p++;
            continue;
            } /* if beyond screen */
         if (*p == 1 && *p != currclr)
            {
            XSetForeground(dpy,gc,blackColor);
            currclr = 1;
            } /* if change to black */
         else if (*p == 2 && *p != currclr)
            {
            XSetForeground(dpy,gc,red);
            currclr = *p;
            } /* if change to red */
         if (*p) XDrawPoint(dpy,w,gc,x-strtcol,y-strtrow);
         p++;
         } /* for each column */
      } /* for each row */
   } /* putwin */

/* X Windows code is based on: */
/* http://tronche.lri.fr:8000/gui/x/xlib-tutorial/2nd-program-anatomy.html */

void initx()
   {
   int i,rslt;
   char title[64];

   dpy = XOpenDisplay(NIL);

   if (dpy == NULL)
      {
      fprintf(stderr,"X Windows failure\n");
      exit(1);
      } /* if X Windows is not active */

   assert(dpy);

   whiteColor = WhitePixel(dpy, DefaultScreen(dpy));
   blackColor = BlackPixel(dpy, DefaultScreen(dpy));

   if (wdt > SCRW) scrwdt = SCRW;
   else scrwdt = wdt;

   if (hgt > SCRH) scrhgt = SCRH;
   else scrhgt = hgt;

   w = XCreateSimpleWindow(dpy,
      DefaultRootWindow(dpy),
      0, 0, 
      scrwdt, scrhgt,
      0, whiteColor,
      whiteColor);

   XSelectInput(dpy, w, StructureNotifyMask);

   XMapWindow(dpy, w);

   gc = XCreateGC(dpy, w, 0, NIL);

   XSetForeground(dpy, gc, blackColor);

   dfltscr = XDefaultScreenOfDisplay(dpy);
   if (dfltscr == NULL)
      {
      fprintf(stderr,"XDefaultScreenOfDisplay failed\n");
      perror("XDefaultScreenOfDisplay failed");
      exit(1);
      } /* if error */

   cmap = XDefaultColormapOfScreen(dfltscr);

   rslt = XAllocNamedColor(dpy,cmap,"red",
      &scrdef,&exctdef);
   if (rslt < 0)
      {
      fprintf(stderr,"XAllocNamedColor failed\n");
      perror("XAllocNamedColor failed");
      exit(1);
      } /* if error */
   red = scrdef.pixel;

   XSetWindowBorderWidth(dpy, w, 40);

   sprintf(title,"gcview");
   XStoreName(dpy,w,title);

   XMoveWindow(dpy,w,0,0);

   while(1)
      {
      XEvent e;
      XNextEvent(dpy, &e);
      if (e.type == MapNotify) break;
      } /* wait for window initialization */

   /* build dome from memory */

   putwin();

   XFlush(dpy);

   /* dome built: wait for shutdown or exposure */

   XSelectInput(dpy, w,
      KeyPressMask|ExposureMask);

   while(1)
      {
      int symbol;
      XEvent e;
      XKeyEvent *k;
      XNextEvent(dpy, &e);
      if (e.type == KeyPress)
         {
         k = (XKeyEvent *) &e;
         symbol = XLookupKeysym(k,0);
         if (symbol == XK_Escape) break;
         else if (symbol == XK_Right)
            {
            if (strtcol < (wdt - SCRW))
               {
               strtcol += SCROLL;
               XClearWindow(dpy,w);
               putwin();
               XFlush(dpy);
               } /* if room to scroll right */
            } /* if scroll right */
         else if (symbol == XK_Left)
            {
            if (strtcol >= SCROLL)
               {
               strtcol -= SCROLL;
               XClearWindow(dpy,w);
               putwin();
               XFlush(dpy);
               } /* if room to scroll left */
            } /* if scroll left */
         else if (symbol == XK_Down)
            {
            if (strtrow < (hgt - SCRH))
               {
               strtrow += SCROLL;
               XClearWindow(dpy,w);
               putwin();
               XFlush(dpy);
               } /* if room to scroll down */
            } /* if scroll down */
         else if (symbol == XK_Up)
            {
            if (strtrow >= SCROLL)
               {
               strtrow -= SCROLL;
               XClearWindow(dpy,w);
               putwin();
               XFlush(dpy);
               } /* if room to scroll up */
            } /* if scroll up */
         } /* if keypress event */
      else if (e.type == Expose)
         {
         putwin();
         XFlush(dpy);
         } /* if expose event */
      } /* wait for window shutdown */
   } /* initx */

void fillmtx()
   {
   int ch,color;
   int sz;
   char *p,*q;
   p = mtx;
   sz = wdt * hgt;
   q = p + sz;
   while (p < q)
      {
      ch = getbyte();
      if (ch == EOF) return;
      else color = ch & 255;
      ch = getbyte();
      if (ch == EOF) ppmeof();
      else color = (color << 8) | (ch & 255);
      ch = getbyte();
      if (ch == EOF) ppmeof();
      else color = (color << 8) | (ch & 255);
      if (color == 0xffffff) *p = 0;
      else if (color == 0) *p = 1;
      else if (color == 0xff0000) *p = 2;
      else
         {
         fprintf(stderr,"Unknown color\n");
         exit(1);
         } /* unknown color */
      p++;
      } /* read loop */
   } /* fillmtx */

int main()
   {
   int ch;
   int getbyte();
   if (getbyte() != 'P') badmagic();
   if (ch == EOF) ppmeof();
   if (getbyte() != '6') badmagic();
   if (ch == EOF) ppmeof();
   while ((ch = getbyte()) == ' ' || ch == '\t'
      || ch == '\n');
   if (ch == EOF) ppmeof();
   wdt = getnum(ch);
   while ((ch = getbyte()) == ' ' || ch == '\t'
      || ch == '\n');
   if (ch == EOF) ppmeof();
   hgt = getnum(ch);
   if (ch == EOF) ppmeof();
   while ((ch = getbyte()) == ' ' || ch == '\t'
      || ch == '\n');
   clrs = getnum(ch);
   printf("width %d height %d colors %d\n",
      wdt, hgt, clrs);
   mtx = (char *) malloc((wdt*hgt) + 32);
   if (mtx == NULL)
      {
      fprintf(stderr,"Out of memory allocating matrix\n");
      exit(1);
      } /* not enough memory */
   fillmtx();
   strtrow = strtcol = 0;
   initx();
   return(0);
   } /* main */
