/*
gcdome Version 2.3.0. Great Circle Geodesic Dome Calculation
Copyright (C) 2001-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define PI M_PI
#define MAXFREQ 32
#define NINETY 90.0
#define MINNUM 0.00000000001
#define NEGZERO(x) { if (x > -MINNUM && x < MINNUM) { x = zero; } }

int freq;
double dblfreq;
double deg2rad,rad2deg,ninety,zero;
double height,heightd,rheight,rheightd;
double pi,lon1,lon2,lon2d;
double lon,lond;
double *phi,*theta,*curphi,*curtheta;
double arclen(),gclat();
char comma[8],newline[8];

void putstx(char *pgm)
   {
   fprintf(stderr,"Usage: %s <frequency>\n", pgm);
   fprintf(stderr,"   Where frequency is 1,2,3...\n", pgm);
   exit(1);
   } /* putstx */

/* Calculate the arc in radians and degrees of */
/* the side of the equilateral triangle of the */
/* icosahedron extending from the north pole to */
/* the vertex of the pentagon at 0 deg. east. */
/* This side of the triangle follows the meridian */
/* at a right angle to the equator and is not */
/* subject to a great circle calculation. */
/* The side of the triangle is a chord.  The */
/* arc is defined by the radius of the sphere */
/* and the length of the chord */
/* The length of the chord = 1 and the radius */
/* of an icosahedron is defined by the irad */
/* formula in arclen.c */
void getheight(dblfreq)
double dblfreq;
   {
   /* Calculate the arc in radians from the */
   /* north pole to the vertex of the pentagon */
   /* at 0 degrees east */
   height = (double) arclen();
   /* Convert the height from radians to degrees. */
   /* The result is 63 degrees from north. */
   heightd = height * rad2deg;
   /* Row height of each horizontal great circle is */
   /* the total height divided by the frequency of */
   /* the geodesic dome */
   rheight = height / dblfreq; /* row height in radians */
   /* The same row height in degrees */
   rheightd = rheight * rad2deg;
   } /* getheight */

void calcvert(freq)
int freq;
   {
   int i,segs,rownum;
   double lonseg;
   double seglon,seglond,dblsegs;
   double seglend;
   double lat,latd,lat1,lat1d,lat2,lat2d;
   dblsegs = dblfreq;
   segs = freq;  /* segments per row */
   seglend = lon2d / dblfreq;
   lat1d = ninety - heightd;
   lat1 = lat1d * deg2rad;
   rownum = 0;
   printf("Spherical Vertexia Coordinates\n");
   while (floor(lat1d) < ninety)
      {
      printf("\nRow %d\n", ++rownum);
      lat2 = lat1;
      lat2d = lat2 * rad2deg;
      seglon = zero;
      printf("%14.11f, %14.11f\n",
         zero, ninety - lat2d);
      for (i=0;i<segs;i++)
         {
         lonseg = seglend * deg2rad;
         seglon += lonseg;
         seglond = seglon * rad2deg;
         /* get mid-course great circle latitude */
         /* in radians */
         lat = (double) gclat(lat1,lon1,lat2,lon2,seglon);
         latd = lat * rad2deg;
         printf("%14.11f, %14.11f\n",
            seglond, ninety - latd);
         } /* for each segment of the great circle */
      lat1 += rheight;
      lat1d += rheightd;
      segs--;
      dblsegs--;
      seglend = lon2d / dblsegs;
      } /* for each row */
   if (rownum < freq + 1)
      {
      printf("\nRow %d\n", ++rownum);
      printf("%14.11f, %14.11f\n", zero, zero);
      }
   } /* calcvert */

void plotcart(phi,theta)
double phi,theta;
   {
   double tmpphi,tmptheta,x,y,z;
   tmpphi   = phi   * deg2rad;
   tmptheta = theta * deg2rad;
   x = sin(tmptheta) * cos(tmpphi);
   y = sin(tmptheta) * sin(tmpphi);
   z = cos(tmptheta);
   NEGZERO(x);
   NEGZERO(y);
   NEGZERO(z);
   printf("%14.11f, %14.11f, %14.11f\n",
      x, y, z);
   } /* plotcart */

void vertcart(freq)
int freq;
   {
   int i,segs,rownum;
   double lonseg;
   double seglon,seglond,dblsegs;
   double seglend;
   double lat,latd,lat1,lat1d,lat2,lat2d;
   dblsegs = dblfreq;
   segs = freq;  /* segments per row */
   seglend = lon2d / dblfreq;
   lat1d = ninety - heightd;
   lat1 = lat1d * deg2rad;
   rownum = 0;
   printf("\nCartesian Vertexia Coordinates\n");
   while (floor(lat1d) < ninety)
      {
      printf("\nRow %d\n", ++rownum);
      lat2 = lat1;
      lat2d = lat2 * rad2deg;
      seglon = zero;
      plotcart(zero,ninety - lat2d);
      for (i=0;i<segs;i++)
         {
         lonseg = seglend * deg2rad;
         seglon += lonseg;
         seglond = seglon * rad2deg;
         /* get mid-course great circle latitude */
         /* in radians */
         lat = (double) gclat(lat1,lon1,lat2,lon2,seglon);
         latd = lat * rad2deg;
         plotcart(seglond,ninety - latd);
         } /* for each segment of the great circle */
      lat1 += rheight;
      lat1d += rheightd;
      segs--;
      dblsegs--;
      seglend = lon2d / dblsegs;
      } /* for each row */
   if (rownum < freq + 1)
      {
      printf("\nRow %d\n", ++rownum);
      plotcart(zero,zero);
      }
   } /* vertcart */

void putlen(fromphi,fromtheta,tophi,totheta,dlm)
double fromphi,fromtheta,tophi,totheta;
char *dlm;
   {
   double phi1,theta1,phi2,theta2,x1,y1,z1,x2,y2,z2;
   double dx,dy,dz,dxsq,dysq,dzsq,sumsq,len;
   phi1   = fromphi   * deg2rad;
   theta1 = fromtheta * deg2rad;
   phi2   = tophi   * deg2rad;
   theta2 = totheta * deg2rad;
   x1 = sin(theta1) * cos(phi1);
   y1 = sin(theta1) * sin(phi1);
   z1 = cos(theta1);
   x2 = sin(theta2) * cos(phi2);
   y2 = sin(theta2) * sin(phi2);
   z2 = cos(theta2);
   NEGZERO(x1);
   NEGZERO(y1);
   NEGZERO(z1);
   NEGZERO(x2);
   NEGZERO(y2);
   NEGZERO(z2);
   dx = x2 - x1;
   dy = y2 - y1;
   dz = z2 - z1;
   dxsq = dx * dx;
   dysq = dy * dy;
   dzsq = dz * dz;
   sumsq = dxsq + dysq + dzsq;
   len = sqrt(sumsq);
   printf("%13.11f%s", len, dlm); 
   } /* putlen */

void plotangl(topphi,toptheta,lftphi,lfttheta,rgtphi,rgttheta)
double topphi,toptheta,lftphi,lfttheta,rgtphi,rgttheta;
   {
   NEGZERO(topphi);
   NEGZERO(toptheta);
   NEGZERO(lftphi);
   NEGZERO(lfttheta);
   NEGZERO(rgtphi);
   NEGZERO(rgttheta);
   printf("%14.11f, %14.11f%s",
      topphi,toptheta,comma);
   printf("%14.11f, %14.11f%s",
      lftphi,lfttheta,comma);
   putlen(topphi,toptheta,lftphi,lfttheta,newline);
   printf("%14.11f, %14.11f%s",
      topphi,toptheta,comma);
   printf("%14.11f, %14.11f%s",
      rgtphi,rgttheta,comma);
   putlen(topphi,toptheta,rgtphi,rgttheta,newline);
   printf("%14.11f, %14.11f%s",
      lftphi,lfttheta,comma);
   printf("%14.11f, %14.11f%s",
      rgtphi,rgttheta,comma);
   putlen(lftphi,lfttheta,rgtphi,rgttheta,newline);
   } /* plotangl */

void cordvert(freq)
int freq;
   {
   int i,segs,rownum;
   double lonseg;
   double seglon,seglond,dblsegs;
   double seglend;
   double lat,latd,lat1,lat1d,lat2,lat2d;
   dblsegs = dblfreq;
   segs = freq;  /* segments per row */
   seglend = lon2d / dblfreq;
   lat1d = ninety - heightd;
   lat1 = lat1d * deg2rad;
   rownum = 0;
   printf("\nSpherical Chord Coordinates and Length\n");
   while (floor(lat1d) <= ninety)
      {
      if (rownum > 0)
         printf("\nRow %d\n", rownum);
      lat2 = lat1;
      lat2d = lat2 * rad2deg;
      seglon = curphi[0] = zero;
      curtheta[0] = ninety - lat2d;
      for (i=0;i<segs;i++)
         {
         lonseg = seglend * deg2rad;
         seglon += lonseg;
         seglond = seglon * rad2deg;
         /* get mid-course great circle latitude */
         /* in radians */
         lat = (double) gclat(lat1,lon1,lat2,lon2,seglon);
         latd = lat * rad2deg;
         curphi[i+1] = seglond;
         curtheta[i+1] = ninety - latd;
         if (rownum > 0)
            {
            plotangl(curphi[i],curtheta[i],
               phi[i],theta[i],phi[i+1],theta[i+1]);
            }
         } /* for each segment of the great circle */
      if (rownum > 0 && rownum < freq + 1)
         {
         plotangl(curphi[i],curtheta[i],
            phi[i],theta[i],phi[i+1],theta[i+1]);
         }
      for (i=0;i<=segs;i++)
         {
         phi[i] = curphi[i];
         theta[i] = curtheta[i];
         }
      lat1 += rheight;
      lat1d += rheightd;
      segs--;
      dblsegs--;
      seglend = lon2d / dblsegs;
      rownum++;
      } /* for each row */
   } /* cordvert */

void putpt(phi,theta,dlm)
double phi,theta;
char *dlm;
   {
   double tmpphi,tmptheta,x,y,z;
   tmpphi   = phi   * deg2rad;
   tmptheta = theta * deg2rad;
   x = sin(tmptheta) * cos(tmpphi);
   y = sin(tmptheta) * sin(tmpphi);
   z = cos(tmptheta);
   NEGZERO(x);
   NEGZERO(y);
   NEGZERO(z);
   printf("%11.8f, %11.8f, %11.8f%s",
      x, y, z, dlm); 
   } /* putpt */

void plotpt(topphi,toptheta,lftphi,lfttheta,rgtphi,rgttheta)
double topphi,toptheta,lftphi,lfttheta,rgtphi,rgttheta;
   {
   putpt(topphi,toptheta,comma);
   putpt(lftphi,lfttheta,newline);
   putpt(topphi,toptheta,comma);
   putpt(rgtphi,rgttheta,newline);
   putpt(lftphi,lfttheta,comma);
   putpt(rgtphi,rgttheta,newline);
   } /* plotpt */

void cordcart(freq)
int freq;
   {
   int i,segs,rownum;
   double lonseg;
   double seglon,seglond,dblsegs;
   double seglend;
   double lat,latd,lat1,lat1d,lat2,lat2d;
   dblsegs = dblfreq;
   segs = freq;  /* segments per row */
   seglend = lon2d / dblfreq;
   lat1d = ninety - heightd;
   lat1 = lat1d * deg2rad;
   rownum = 0;
   printf("\nCartesian Chord Coordinates\n");
   while (floor(lat1d) <= ninety)
      {
      if (rownum > 0)
         printf("\nRow %d\n", rownum);
      lat2 = lat1;
      lat2d = lat2 * rad2deg;
      seglon = curphi[0] = zero;
      curtheta[0] = ninety - lat2d;
      for (i=0;i<segs;i++)
         {
         lonseg = seglend * deg2rad;
         seglon += lonseg;
         seglond = seglon * rad2deg;
         /* get mid-course great circle latitude */
         /* in radians */
         lat = (double) gclat(lat1,lon1,lat2,lon2,seglon);
         latd = lat * rad2deg;
         curphi[i+1] = seglond;
         curtheta[i+1] = ninety - latd;
         if (rownum > 0)
            {
            plotpt(curphi[i],curtheta[i],
               phi[i],theta[i],phi[i+1],theta[i+1]);
            }
         } /* for each segment of the great circle */
      if (rownum > 0 && rownum < freq + 1)
         {
         plotpt(curphi[i],curtheta[i],
            phi[i],theta[i],phi[i+1],theta[i+1]);
         }
      for (i=0;i<=segs;i++)
         {
         phi[i] = curphi[i];
         theta[i] = curtheta[i];
         }
      lat1 += rheight;
      lat1d += rheightd;
      segs--;
      dblsegs--;
      seglend = lon2d / dblsegs;
      rownum++;
      } /* for each row */
   } /* cordcart */

int main(argc,argv)
int argc;
char **argv;
   {
   if (argc != 2) putstx(*argv);
   freq = atoi(*(argv+1)); 
   if (freq < 1) putstx(*argv);
   else if (freq > MAXFREQ)
      {
      fprintf(stderr,"Frequency %d too large\n", freq);
      fprintf(stderr,"Maximum frequency is %d\n", MAXFREQ);
      putstx(*argv);
      }
   dblfreq  = (double) freq;
   /* previous row of angles */
   phi      = (double *) malloc(sizeof(double)*(freq+32));
   theta    = (double *) malloc(sizeof(double)*(freq+32));
   /* current row of angles */
   curphi   = (double *) malloc(sizeof(double)*(freq+32));
   curtheta = (double *) malloc(sizeof(double)*(freq+32));
   /* delimiters between angles and coordinates */
   strcpy(comma,", ");
   strcpy(newline,"\n");
   /* constants */
   zero = 0.0;
   ninety = NINETY;
   pi = PI;
   /* degree to radian conversion factors */
   deg2rad = pi / 180.0;
   rad2deg = 180.0 / pi;
   /* Calculate dimensions of one equilateral triangle */
   /* in the polar 3D pentagon of the icosahedron */
   /* This equilateral extends from the north pole */
   /* to  0 deg. east and 63 deg. from the north pole */
   /* on the left and... */
   /* to 72 deg. east and 63 deg. from the north pole */
   /* on the right. */
   /* Source longitude in the great circle. */
   lon1 = zero;
   /* Target longitude in the great circle. */
   lon2d = 72.0;
   lon2 = lon2d * deg2rad;
   getheight(dblfreq);
   calcvert(freq);
   vertcart(freq);
   cordvert(freq);
   cordcart(freq);
   return(0);
   } /* main */
