#!/usr/bin/perl

# genc2m3.pl Version 2.3.0
# Copyright (C) 2001-2010  dondalah721@yahoo.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

# This script creates a C source file for compiling
# a Class II Method 3 icosahedron geodesic sphere
# top symmetry triangle.

$FREQ = shift @ARGV;

if ($FREQ < 1)
   {
   print STDERR "Frequency too small.\n";
   die;
   }
elsif ($FREQ > 32)
   {
   print STDERR "Frequency is 2,4,6,...,32.\n";
   die;
   }
$TMP = $FREQ % 2;
die "Frequency $FREQ is not an even number"
   if ($TMP);
$HFREQ = $FREQ / 2;

print "#include <stdio.h>\n";
print "#include <math.h>\n\n";

print "#define PI M_PI\n";
print "#define D2R PI/d180\n";
print "#define R2D d180/PI\n\n";

print "/* Copyright (C) 2001-2010  dondalah\@ripco.com (Dondalah) */\n";
print "/* Octahedron Frequency = $FREQ */\n";
print "/* This program is protected by the GNU Public License. */\n";
print "/* See http://www.gnu.org/copyleft/gpl.html. */\n";

print "\nmain()\n";
print "   {\n";
print "   double freq,hfreq\;\n";
$I = 0;
while ($I <= $HFREQ)
   {
   print "   double d$I\;\n";
   $I++;
   }
if ($HFREQ < 5)
   {
   print "   double d5\;\n";
   }
print "   /* Declare conversion factors between */\n";
print "   /* degrees and radians: */\n";
print "   double d2r,r2d,d45,d90,d180,d225\;\n";
print "   double phideg,thetadeg,dist\;\n";
print "   double d45rad,d90rad,tantheta\;\n";
print "   double phi_225,cosa\;\n";
print "   /* Declare vertex angles */\n";
print "   /* Phi is angle south from ";
print "the zenith (North Pole). */\n";
print "   /* Theta is angle east from ";
print "0 deg. meridian. */\n";
$I = 0;
while ($I <= $HFREQ)
   {
   printf "   double theta%dmed\;\n", $I;
   $J = 0;
   while ($J <= $I)
      {
      print "   double phi$I$J\;\n";
      print "   double theta$I$J\;\n";
      $J++;
      } # col (0 - curr hfreq)
   $I++;
   } # declare doubles by row (0 - hfreq)
print "   /* Declare geodesic math functions. */\n";
print "   /* Equation 14.2 */\n";
print "   double rotphi()\;\n";
print "   /* Equation 14.1 */\n";
print "   double rottheta()\;\n";
print "   /* Equation 9.2 */\n";
print "   double getdist()\;\n";
print "   freq  = $FREQ\;\n";
print "   hfreq = $HFREQ\;\n";
print "   d45  =  45.0\;\n";
print "   d90  =  90.0\;\n";
print "   d180 = 180.0\;\n";
print "   d225 = 225.0\;\n";
print "   d2r  = D2R\;\n";
print "   r2d  = R2D\;\n";
print "   d45rad  =  d45 * d2r\;\n";
print "   d90rad  =  d90 * d2r\;\n";
print "   phi_225  =  d225 * d2r\;\n";
$I = 0;
while ($I <= $HFREQ)
   {
   print "   d$I = $I.0\;\n";
   $I++;
   }
if ($HFREQ < 5)
   {
   print "   d5 = 5.0\;\n";
   }
print  "   phi00 = d0\;\n";
print  "   theta00 = d0\;\n";
print  "   /* Appendix I Step 1 */\n";
printf "   theta%dmed = d45rad\;\n", $HFREQ;
printf "   theta1med = theta%dmed / d%d\;\n", $HFREQ, $HFREQ;
print  "   cosa = cos(d45rad)\;\n";
$I = 1;
while ($I <= $HFREQ)
   {
   printf "   phi%d0 = d0\;\n", $I;
   printf "   phi%d%d = d90rad\;\n", $I, $I;
   printf "   theta%dmed = theta1med * d%d\;\n", $I, $I;
   printf "   tantheta   = tan(theta%dmed)\;\n", $I;
   printf "   theta%d0  = atan(tantheta / cosa)\;\n", $I;
   printf "   theta%d%d = theta%d0\;\n", $I, $I, $I;
   $I++;
   } # calc edge phi & theta
print "   phi21   = d45rad\;\n";
print "   theta21 = theta2med\;\n";
$I = 3;
while ($I <= $HFREQ)
   {
   $J = 1;
   while ($J < $I)
      {
      $TMP = $J/$I;
      if ($TMP == 0.5)
         {
         printf "   phi%d%d = d45rad\;\n", $I, $J;
         printf "   theta%d%d = theta%dmed\;\n", $I, $J, $I;
         }
      elsif ($TMP < 0.5)
         {
         $ROTMED = $J * 2;
         printf "   theta%d%d = rottheta(phi_225,theta%dmed,", $I, $J, $ROTMED;
         printf "phi%d0,theta%d0)\;\n", $I-$ROTMED, $I-$ROTMED;
         printf "   phi%d%d = rotphi(phi_225,phi%d0,", $I, $J, $I-$ROTMED;
         printf "theta%d0,theta%d%d)\;\n", $I-$ROTMED, $I, $J;
         printf "   phi%d%d += d45rad\;\n", $I, $J;
         } # < median
      else  # $TMP > 0.5
         {
         $ROTMED = ($I - $J) * 2;
         printf "   theta%d%d = rottheta(phi_225,theta%dmed,", $I, $J, $ROTMED;
         printf "phi%d%d,", $I-$ROTMED, $I-$ROTMED;
         printf "theta%d%d)\;\n", $I-$ROTMED, $I-$ROTMED;
         # printf "   theta%d%d = theta%d%d\;\n", $I, $J, $I, $I-$J;
         printf "   phi%d%d = rotphi(phi_225,", $I, $J;
         printf "phi%d%d,", $I-$ROTMED, $I-$ROTMED;
         printf "theta%d%d,", $I-$ROTMED, $I-$ROTMED;
         printf "theta%d%d)\;\n", $I, $J;
         printf "   phi%d%d += d45rad\;\n", $I, $J;
         } # > median
      $J++;
      } # y: calculate by col (0 - 90 deg)
   $I++;
   } # x: calculate by row (0 - rowct)
print "   printf(\"Class II Method 3 Icosahedron, %.0f Frequency\\n\\n\",\n";
print "      freq)\;\n";
print "   printf(\"Top Symmetry Triangle\\n\")\;\n";
print "   printf(\"Vertex Coordinates\\n\")\;\n";
print "   printf(\"0,0 %20.15f, %20.15f\\n\", d0, d0)\;\n";
$I = 1;
while ($I <= $HFREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      print "   phideg   = phi$I$J * r2d\;\n";
      print "   thetadeg = theta$I$J * r2d\;\n";
      print "   printf(\"$I,$J %20.15f, %20.15f\\n\",";
      print " phideg, thetadeg)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 90 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)
print "   printf(\"\\nTop Symmetry Triangle\\n\")\;\n";
print "   printf(\"Chord Lengths, Radius = 1\\n\")\;\n";
print "   dist = getdist(d0, d0,";
print " phi10,theta10)\;\n";
print "   printf(\"0,0 - 1,0";
print " %20.15f\\n\", dist)\;\n";
print "   dist = getdist(d0,d0,";
print " phi11,theta11)\;\n";
print "   printf(\"0,0 - 1,1";
print " %20.15f\\n\", dist)\;\n";
print "   dist = getdist(phi10,theta10,";
print " phi11,theta11)\;\n";
print "   printf(\"1,0 - 1,1";
print " %20.15f\\n\", dist)\;\n";
$I = 1;
$BOT = $HFREQ - 1;
while ($I <= $BOT)
   {
   $J = 0;
   while ($J <= $I)
      {
      $K = $I + 1;
      $L = $J + 1;
      print "   /* I = $I this row */\n";
      print "   /* J = $J column this row */\n";
      print "   /* K = $K next row */\n";
      print "   /* L = $L next column next row */\n";
      print "   dist = getdist(phi$I$J,theta$I$J,";
      print " phi$K$J,theta$K$J)\;\n";
      print "   printf(\"$I,$J - $K,$J";
      print " %20.15f\\n\", dist)\;\n";
      print "   dist = getdist(phi$I$J,theta$I$J,";
      print " phi$K$L,theta$K$L)\;\n";
      print "   printf(\"$I,$J - $K,$L";
      print " %20.15f\\n\", dist)\;\n";
      print "   dist = getdist(phi$K$J,theta$K$J,";
      print " phi$K$L,theta$K$L)\;\n";
      print "   printf(\"$K,$J - $K,$L";
      print " %20.15f\\n\", dist)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 90 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)
print "   return(0)\;\n";
print "   }\n";
