/*
rotphi.c Version 2.3.0
Copyright (C) 2001-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* From Hugh Kenner */
/* Geodesic math and how to use it */
/* Berkeley: University of California Press, 1976 */
/* ISBN: 0-520-02924-0 */

/* equation 14.2 */
/* The rotation formula tells us that when phi,theta */
/* moves to 0,0, then phi1 moves to phi2. */

double rotphi(phi,phi1,theta1,theta2)
double phi,phi1,theta1,theta2;
   {
   double phi2,diff,prod,dvsr,quot;
   diff = phi - phi1;
   prod = sin(theta1) * sin(diff);
   dvsr = sin(theta2);
   if (dvsr == 0.0)
      {
      fprintf(stderr,"rotphi: Division by zero.\n");
      exit(1);
      }
   quot = prod / dvsr;
   phi2 = asin(quot);
   return(phi2);
   } /* rotphi */
