/*
gclat Version 2.2.0. Calculate the latitude of
a mid point along a great circle route.
Copyright (C) 2001  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <math.h>

/* Get mid-course great circle latitude in radians. */
/* The formula for great circle latitude comes from */
/* Aviation Formulary Version 1.25 */
/* http://www.best.com/~williams/avform.html */
/* by Ed Williams */
/* http://www.best.com/~williams/index.html */
/* E-mail address:  72347.1516@CompuServe.COM */

double gclat(lat1,lon1,lat2,lon2,lon)
double lat1,lon1,lat2,lon2,lon;
   {
   double lat;
   lat = atan((sin(lat1) * cos(lat2) * sin(lon - lon2)
   	- sin(lat2) * cos(lat1) * sin(lon - lon1))
   	/ (cos(lat1) * cos(lat2) * sin(lon1 - lon2)));
   return(lat);
   } /* gclat */
