/*
arclen.c Version 2.2.0. Calculate the arc in radians
from the north pole to the vertex of the polar pentagon
of an icosahedron at 0 degrees east.
Copyright (C) 2001  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <math.h>

/* Calculate the arc in radians and degrees of */
/* the side of the equilateral triangle of the */
/* icosahedron extending from the north pole to */
/* the vertex of the pentagon at 0 deg. east. */
/* This side of the triangle follows the meridian */
/* at a right angle to the equator and is not */
/* subject to a great circle calculation. */
/* The side of the triangle is a chord.  The */
/* arc is defined by the radius of the sphere */
/* and the length of the chord */
/* The length of the chord = 1 and the radius */
/* of an icosahedron is defined by the irad */
/* formula below. */
/* The formula for the radius of an icosahedron */
/* comes from CRC Standard Mathematical Tables, */
/* The Chemical Rubber Company. */

double arclen()
   {
   double irad,triah,doverr,arc;
   double getirad();
   /* To calculate 63 deg. from the north pole... */
   /* first calculate the radius of the icosahedron */
   /* whose side length = 1 */
   irad = getirad();
   /* Calculate the height of the triangle formed by the */
   /* center of the sphere, the north pole, and */
   /* the vertex of the pentagon at 0 deg E. */
   triah = sqrt(irad * irad - 0.25);
   /* Calculate the angle at the center of the */
   /* sphere for this triangle */
   /* The result is the height in radians between the */
   /* north pole and the vertex of the pentagon at 0 deg E. */
   /* This formula also comes from */
   /* CRC Standard Mathematical Tables, */
   /* The Chemical Rubber Company. */
   doverr = triah / irad;
   arc = 2.0 * acos(doverr);
   return(arc);
   } /* arclen */
