#!/usr/bin/perl

# calclen.pl Version 2.2.0
# Copyright (C) 2001  dondalah@ripco.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

$RADIUS = shift @ARGV;
if ($RADIUS eq "")
   {
   die "Parameter is dome radius";
   }
$RADSQ = $RADIUS * $RADIUS;
while ($LN = <>)
   {
   chop($LN);
   $LN =~ s/\s+/ /g;
   $LEN = length($LN);
   next if ($LEN < 8);
   @FLD = split(/, /,$LN);
   $TTL = substr($LN,0,15);
   last if ($TTL eq "Cartesian Chord");
   }
while ($LN = <>)
   {
   chop($LN);
   $LN =~ s/\s+/ /g;
   $LEN = length($LN);
   next if ($LEN < 8);
   @FLD = split(/, /,$LN);
   $DX = $FLD[1] - $FLD[4];
   $DY = $FLD[0] - $FLD[3];
   $DZ = $FLD[2] - $FLD[5];
   $DXSQ = $DX * $DX * $RADSQ;
   $DYSQ = $DY * $DY * $RADSQ;
   $DZSQ = $DZ * $DZ * $RADSQ;
   $LEN = sqrt($DXSQ + $DYSQ + $DZSQ);
   print "$LEN\n";
   }
