#!/usr/bin/perl

# bldvtx.pl Version 2.2.0
# Copyright (C) 2001  dondalah@ripco.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

keys %PHI   = 8192;
keys %THETA = 8192;

$FREQ = shift @ARGV;
if ($FREQ < 1 || $FREQ > 32)
   {
   die "Frequency is 1-32\n";
   } # if invalid frequency
$LN = <>;

$ROW = $FREQ;
while ($ROW >= 0)
   {
   $LN = <>;  # blank line
   $LN = <>;  # ROW %d (bottom row is row 1)
   # row numbers are converted:
   # top row becomes row 0
   # bottom row becomes row $FREQ-1
   $COL = 0;
   while ($COL <= $ROW)
      {
      $ROWCOL = sprintf "%d,%d", $ROW, $COL;
      $LN = <>;
      chop($LN);
      $LN =~ s/^\s+//;
      $LN =~ s/\s+/ /g;
      @FLD = split(/,/,$LN);
      $PHI{$ROWCOL}   = $FLD[0];
      $THETA{$ROWCOL} = $FLD[1];
      $COL++;
      } # for each column within each row
   $ROW--;
   } # for each row

$ROW = 0;
while ($ROW < $FREQ)
   {
   $COL = 0;
   while ($COL <= $ROW)
      {
      $ROWCOL = sprintf "%d,%d", $ROW, $COL;
      print "$PHI{$ROWCOL},";
      print "$THETA{$ROWCOL}, ";
      $ROWCOL = sprintf "%d,%d", $ROW+1, $COL;
      print "$PHI{$ROWCOL},";
      print "$THETA{$ROWCOL}\n";

      $ROWCOL = sprintf "%d,%d", $ROW, $COL;
      print "$PHI{$ROWCOL},";
      print "$THETA{$ROWCOL}, ";
      $ROWCOL = sprintf "%d,%d", $ROW+1, $COL+1;
      print "$PHI{$ROWCOL},";
      print "$THETA{$ROWCOL}\n";

      $ROWCOL = sprintf "%d,%d", $ROW+1, $COL;
      print "$PHI{$ROWCOL},";
      print "$THETA{$ROWCOL}, ";
      $ROWCOL = sprintf "%d,%d", $ROW+1, $COL+1;
      print "$PHI{$ROWCOL},";
      print "$THETA{$ROWCOL}\n";
      $COL++;
      } # by COL
   $ROW++;
   } # by ROW
