/*
vtx2ppm.c Version 2.2.0. PPM program for an icosacap triangle
Copyright (C) 2001  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <asm/errno.h>
#include <zlib.h>
#include <math.h>

#define PI M_PI
#define MAXFREQ 32
#define MINNUM 0.00000000001
#define NEGZERO(x) { if (x > -MINNUM && x < MINNUM) { x = zero; } }
#define SZ 480.0
#define XSZ 480
#define YSZ 360

int freq,eofsw;
double deg2rad,zero;

char mtx[YSZ][XSZ];

void putstx(pgm)
   {
   fprintf(stderr,"Usage: %s <frequency>\n", pgm);
   fprintf(stderr,"   Where frequency is 1,2,3...\n", pgm);
   exit(1);
   } /* putstx */

void putimg(hndl,str,len)
gzFile hndl;
unsigned char *str;
int len;
   {
   int wrtlen,tot;
   tot = 0;
   while (tot < len)
      {
      wrtlen = gzwrite(hndl,str,len);
      if (wrtlen < 1)
         {
         fprintf(stderr,"Write error %d\n", errno);
         perror("Write error");
         exit(1);
         } /* write err */
      tot += wrtlen;
      } /* write loop */
   } /* putimg */

void wrtppm(hndl)
gzFile hndl;
   {
   int len,x,y;
   unsigned char str[32];
   putimg(hndl,"P6\n",3);
   sprintf(str,"%d %d\n%d\n",
      XSZ, YSZ, 255);
   len = strlen(str);
   putimg(hndl,str,len);
   for (y=0;y<YSZ;y++)
      {
      for (x=0;x<XSZ;x++)
         {
         if (mtx[y][x])
            {
            str[0] = str[1] = str[2] = 0;
            } /* if black */
         else
            {
            str[0] = str[1] = str[2] = 255;
            } /* else white */
         putimg(hndl,str,3);
         } /* for each col in mtx */
      } /* for each row in mtx */
   } /* wrtppm */

void drawline(dblx1,dbly1,dblx2,dbly2)
   double dblx1,dbly1,dblx2,dbly2;
   {
   int x1,y1,x2,y2;
   int x,y,dx,dy,xdlta,ydlta,absxdlta,absydlta;
   int xchg,ychg,xlim,ylim;
   x1 = (int) dblx1;
   y1 = (int) dbly1;
   x2 = (int) dblx2;
   y2 = (int) dbly2;
   if (x1 < 0 || x1 > XSZ)
      {
      fprintf(stderr,"x1 %d out of range\n", x1);
      return;
      } /* x1 err */
   if (y1 < 0 || y1 > YSZ)
      {
      fprintf(stderr,"y1 %d out of range\n", y1);
      return;
      } /* y1 err */
   if (x2 < 0 || x2 > XSZ)
      {
      fprintf(stderr,"x2 %d out of range\n", x2);
      return;
      } /* x2 err */
   if (y2 < 0 || y2 > YSZ)
      {
      fprintf(stderr,"y2 %d out of range\n", y2);
      return;
      } /* y2 err */
   if (x1 < x2)
      {
      dx = x2 - x1;
      dy = y2 - y1;
      if (dy) xdlta = (dx << 8) / dy;
      else xdlta = 256;
      ydlta = (dy << 8) / dx;
      x = x1;
      y = y1;
      xlim = x2;
      ylim = y2;
      } /* if slope to right */
   else if (x1 > x2)
      {
      dx = x1 - x2;
      dy = y1 - y2;
      if (dy) xdlta = (dx << 8) / dy;
      else xdlta = 256;
      ydlta = (dy << 8) / dx;
      x = x2;
      y = y2;
      xlim = x1;
      ylim = y1;
      } /* if slope to left */
   else
      {
      x = x1;
      y = y1;
      if (y2 > y1)
         {
         y = y1;
         ylim = y2;
         } /* if y2 > y1 */
      else
         {
         y = y2;
         ylim = y1;
         } /* else y1 > y2 */
      while (y < ylim)
         mtx[y++][x] = 1;
      return;
      } /* vertical line */
   if (xdlta < 0) absxdlta = -xdlta;
   else absxdlta = xdlta;
   if (ydlta < 0) absydlta = -ydlta;
   else absydlta = ydlta;
   xchg = 0;
   ychg = 0;
   while (x < xlim)
      {
      xchg += absxdlta;
      if (xchg > 256)
         {
         if (x <= xlim) x++;
         xchg -= 256;
         } /* if whole number */
      ychg += absydlta;
      if (ychg > 128)
         {
         if (ydlta < 0)
            {
            if (y >= ylim) y--;
            } /* if negative slope */
         else
            {
            if (y <= ylim) y++;
            } /* if positive slope */
         ychg -= 256;
         } /* if whole number */
      mtx[y][x] = 1;
      } /* draw line */
   } /* drawline */

void putppm(phi1,theta1,phi2,theta2)
double phi1,theta1,phi2,theta2;
   {
   double tmpphi,tmptheta,x1,y1,z1,x2,y2,z2;
   double toprow;
   toprow = SZ + 32.0;
   tmpphi   = phi1   * deg2rad;
   tmptheta = theta1 * deg2rad;
   x1 = sin(tmptheta) * cos(tmpphi) * SZ;
   y1 = sin(tmptheta) * sin(tmpphi) * SZ + 32.0;
   z1 = toprow - cos(tmptheta) * SZ;
   NEGZERO(x1);
   NEGZERO(y1);
   NEGZERO(z1);
   tmpphi   = phi2   * deg2rad;
   tmptheta = theta2 * deg2rad;
   x2 = sin(tmptheta) * cos(tmpphi) * SZ;
   y2 = sin(tmptheta) * sin(tmpphi) * SZ + 32.0;
   z2 = toprow - cos(tmptheta) * SZ;
   NEGZERO(x2);
   NEGZERO(y2);
   NEGZERO(z2);
   drawline(y1, z1, y2, z2);	
   } /* putppm */

double getfld()
   {
   int ch;
   double theta;
   char *p;
   char str[128];
   p = str;
   while ((ch = getchar()) != ' '
      && ch != '\n'
      && ch != EOF)
      *p++ = ch;
   if (ch == EOF)
      {
      eofsw = 1;
      return(0.0);
      }
   *p = '\0';
   theta = (double) atof(str);
   return(theta);
   } /* getfld */

void getline()
   {
   double phi1,theta1,phi2,theta2;
   phi1   = (double) getfld();
   if (eofsw) return;
   theta1 = (double) getfld();
   if (eofsw) return;
   phi2   = (double) getfld();
   if (eofsw) return;
   theta2 = (double) getfld();
   if (eofsw) return;
   putppm(phi1,theta1,phi2,theta2);
   } /* getline */

void getinpt()
   {
   int rslt;
   char fname[128];
   gzFile hndl;

   eofsw = 0;
   while (!eofsw)
      {
      getline();
      }
   sprintf(fname,"%d.ppm.gz", freq);
   /* wb9 for maximum compression */
   hndl = gzopen(fname,"wb9");
   if (hndl == NULL)
      {
      fprintf(stderr,"Open error");
      perror("Open error");
      exit(1);
      } /* open err */
   wrtppm(hndl);
   rslt = gzclose(hndl);
   if (rslt < 0)
      {
      fprintf(stderr,"Close error");
      perror("Close error");
      exit(1);
      } /* close err */
   } /* getinpt */

int main(argc,argv)
int argc;
char **argv;
   {
   int x,y;
   if (argc != 2) putstx(*argv);
   freq = atoi(*(argv+1)); 
   if (freq < 1) putstx(*argv);
   else if (freq > MAXFREQ)
      {
      fprintf(stderr,"Frequency %d too large\n", freq);
      fprintf(stderr,"Maximum frequency is %d\n", MAXFREQ);
      putstx(*argv);
      }
   deg2rad = PI / 180.0;
   zero = 0.0;
   for (y=0;y<YSZ;y++)
      {
      for (x=0;x<XSZ;x++) mtx[y][x] = 0;
      } /* for each row */
   getinpt();
   return(0);
   } /* main */
