/*
getdist.c Version 2.2.0
Copyright (C) 2001  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <math.h>

/* From Hugh Kenner */
/* Geodesic math and how to use it */
/* Berkeley: University of California Press, 1976 */
/* ISBN: 0-520-02924-0 */

/* Equation 9.2 */
/* This formula calculates chord length */
/* based on the coordinates of each end of */
/* the chord on the surface of a geodesic
/* sphere. */
/* This function may be used to calculate */
/* the chord lengths of a symmetry triangle. */

/* The Class I coordinate values of the chord */
/* are obtained with calcphi(x,y) and */
/* calctheta(x,y,z,freq). */

/* Values of x,y,z in a 2v icosacap triangle

   First  digit is x.
   Second digit is y.
   Third  digit is z.

                            0,0,2
                             /\
                           /   \
                         /      \
                       /         \
               0,1,1  ------------  1,0,1
                    / \          / \
                  /    \       /    \
                /       \    /       \
              /          \ /          \
             --------------------------
          0,2,0         1,1,0        2,0,0

*/

double getdist(phi1,theta1,phi2,theta2)
double phi1,theta1,phi2,theta2;
   {
   double term1,term2,sum,diff,dist;
   term1 = cos(theta1) * cos(theta2);
   term2 = cos(phi1 - phi2) * sin(theta1) * sin(theta2);
   sum = term1 + term2;
   diff = 2.0 - (2.0 * sum);
   dist = sqrt(diff);
   return(dist);
   } /* getdist */
