#!/usr/bin/perl

# genc1.pl Version 2.2.0
# Copyright (C) 2001  dondalah@ripco.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

$FREQ = shift @ARGV;

if ($FREQ < 1)
   {
   print STDERR "Frequency too small.\n";
   die;
   }
elsif ($FREQ > 32)
   {
   print STDERR "Frequency too large.\n";
   print STDERR "Use Class II Method 3 with a truss design.\n";
   die;
   }

print "/* Copyright (C) 2001  dondalah\@ripco.com (Dondalah) */\n";
print "/* Octahedron Frequency = $FREQ */\n";
print "/* This program is protected by the GNU Public License. */\n";
print "/* See http://www.gnu.org/copyleft/gpl.html. */\n";

print "#include <stdio.h>\n";
print "#include <math.h>\n\n";

print "#define PI M_PI\n";
print "#define D2R PI/d180\n";
print "#define R2D d180/PI\n\n";

print "\nmain()\n";
print "   {\n";
print "   double freq\;\n";
$I = 0;
while ($I <= $FREQ)
   {
   print "   double d$I\;\n";
   $I++;
   }
if ($FREQ < 5)
   {
   print "   double d5\;\n";
   }
print "   /* Declare conversion factors between */\n";
print "   /* degrees and radians: */\n";
print "   double d2r,r2d,d180\;\n";
print "   double phideg,thetadeg,dist\;\n";
print "   /* Declare vertex angles */\n";
print "   /* Phi is angle south from ";
print "the zenith (North Pole). */\n";
print "   /* Theta is angle east from ";
print "0 deg. meridian. */\n";
$I = 0;
while ($I <= $FREQ)
   {
   $J = $I;
   while ($J <= $I)
      {
      $K = 0;
      while ($K <= $I)
         {
         print "   double phi$J$K\;\n";
         print "   double theta$J$K\;\n";
         $K++;
         } # y
      $J++;
      } # x
   $I++;
   } # declare doubles by row (0 - freq)
print "   /* Declare geodesic math functions. */\n";
print "   /* Equation 12.1 */\n";
print "   double getphi()\;\n";
print "   /* Equation 12.2 */\n";
print "   double gettheta()\;\n";
print "   /* Equation 9.2 */\n";
print "   double getdist()\;\n";
print "   freq = $FREQ\;\n";
print "   d180 = 180.0\;\n";
print "   d2r = D2R\;\n";
print "   r2d = R2D\;\n";
$I = 0;
while ($I <= $FREQ)
   {
   print "   d$I = $I.0\;\n";
   $I++;
   }
if ($FREQ < 5)
   {
   print "   d5 = 5.0\;\n";
   }
$I = 0;
while ($I <= $FREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      $Y = $I - $J;
      $X = $I - $Y;
      $Z = $FREQ - $X - $Y;
      print "   /* I = Row = $I */\n";
      print "   /* J = Col = $J */\n";
      print "   /* X = $X */\n";
      print "   /* Y = $Y */\n";
      print "   /* Z = $Z */\n";
      print "   phi$I$J   = getphi(d$X,d$Y)\;\n";
      print "   theta$I$J = gettheta(";
      print "d$X,d$Y,d$Z)\;\n";
      $J++;
      } # y: calculate by col (0 - 72 deg)
   $I++;
   } # x: calculate by row (0 - rowct)
print "   printf(\"Class I Octahedron, %.0f Frequency\\n\\n\",\n";
print "      freq)\;\n";
print "   printf(\"Octahedron Triangle\\n\")\;\n";
print "   printf(\"Vertex Coordinates\\n\")\;\n";
print "   printf(\"0,0 %20.15f, %20.15f\\n\", d0, d0)\;\n";
$I = 1;
while ($I <= $FREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      print "   phideg   = phi$I$J * r2d\;\n";
      print "   thetadeg = theta$I$J * r2d\;\n";
      print "   printf(\"$I,$J %20.15f, %20.15f\\n\",";
      print " phideg, thetadeg)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 72 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)
print "   printf(\"\\nOctahedron Triangle\\n\")\;\n";
print "   printf(\"Chord Lengths, Radius = 1\\n\")\;\n";
print "   dist = getdist(d0, d0,";
print " phi10,theta10)\;\n";
print "   printf(\"0,0 - 1,0";
print " %20.15f\\n\", dist)\;\n";
print "   dist = getdist(d0,d0,";
print " phi11,theta11)\;\n";
print "   printf(\"0,0 - 1,1";
print " %20.15f\\n\", dist)\;\n";
print "   dist = getdist(phi10,theta10,";
print " phi11,theta11)\;\n";
print "   printf(\"1,0 - 1,1";
print " %20.15f\\n\", dist)\;\n";
$I = 1;
$BOT = $FREQ - 1;
while ($I <= $BOT)
   {
   $J = 0;
   while ($J <= $I)
      {
      $K = $I + 1;
      $L = $J + 1;
      print "   /* I = $I this row */\n";
      print "   /* J = $J column this row */\n";
      print "   /* K = $K next row */\n";
      print "   /* L = $L next column next row */\n";
      print "   dist = getdist(phi$I$J,theta$I$J,";
      print " phi$K$J,theta$K$J)\;\n";
      print "   printf(\"$I,$J - $K,$J";
      print " %20.15f\\n\", dist)\;\n";
      print "   dist = getdist(phi$I$J,theta$I$J,";
      print " phi$K$L,theta$K$L)\;\n";
      print "   printf(\"$I,$J - $K,$L";
      print " %20.15f\\n\", dist)\;\n";
      print "   dist = getdist(phi$K$J,theta$K$J,";
      print " phi$K$L,theta$K$L)\;\n";
      print "   printf(\"$K,$J - $K,$L";
      print " %20.15f\\n\", dist)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 72 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)
print "   return(0)\;\n";
print "   }\n";
