/*
gettau.c Version 2.2.0
Copyright (C) 2001  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <math.h>

#define PI M_PI

/* From Hugh Kenner */
/* Geodesic math and how to use it */
/* Berkeley: University of California Press, 1976 */
/* ISBN: 0-520-02924-0 */

/* This formula is used in the calculation of z1 */
/* in Equation 12.6.  See getz.c */
/* The constant tau is used in a Class I calculation */
/* of a geodesic sphere */

/* Tau is called the golden proportion: */
/*    (1 + sqrt(5)) / 2    */
/*    or 1.61803399        */
/*    or 2 * cos(36)       */

double gettau()
   {
   double tau,rad36;
   double cos36,cos36deg;
   rad36 = 36.0 * PI / 180.0;
   tau = (double) (2.0 * cos(rad36));
   return(tau);
   } /* gettau */
