#!/usr/bin/perl

# gensph.pl Version 2.2.0
# Copyright (C) 2001  dondalah@ripco.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

$FREQ = shift @ARGV;

if ($FREQ < 2)
   {
   print STDERR "Frequency too small.\n";
   die;
   }
elsif ($FREQ > 32)
   {
   print STDERR "Frequency too large.\n";
   print STDERR "Use Class II Method 3 with a truss design.\n";
   die;
   }

$HALFFREQ = int(($FREQ + 1) / 2);
$ODD = $FREQ % 2;

print "/* Copyright (C) 2001  dondalah\@ripco.com (Dondalah) */\n";
print "/* Icosahedron Half Sphere */\n";
print "/* Frequency = $FREQ */\n";
print "/* This program is protected by the GNU Public License. */\n";
print "/* See http://www.gnu.org/copyleft/gpl.html. */\n";

print "#include <stdio.h>\n";
print "#include <math.h>\n\n";

print "#define PI M_PI\n";
print "#define D2R PI/d180\n";
print "#define R2D d180/PI\n\n";

print "\nmain()\n";
print "   {\n";
print "   double freq,dblfreq,hlffreq\;\n";
$I = 0;
while ($I <= $FREQ)
   {
   print "   double d$I\;\n";
   $I++;
   }
if ($FREQ < 5)
   {
   print "   double d5\;\n";
   }
print "   /* Declare conversion factors between */\n";
print "   /* degrees and radians: */\n";
print "   double d2r,r2d,d180\;\n";
print "   double d36,rad36,d144,rad144\;\n";
print "   double phideg,thetadeg,dist\;\n";
print "   /* Declare vertex angles */\n";
print "   /* Phi is angle south from ";
print "the zenith (North Pole). */\n";
print "   /* Theta is angle east from ";
print "0 deg. meridian. */\n";
print "   /* Icosacap vertices */\n";
$I = 0;
while ($I <= $FREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      print "   double phi$I$J\;\n";
      print "   double theta$I$J\;\n";
      $J++;
      } # declare doubles by col (0 - row)
   $I++;
   } # declare doubles by row (0 - freq)

print "   /* For the mid-point of an odd frequency */\n";
$I = 1;
while ($I <= $FREQ)
   {
   printf "   double phi%dmed\;\n", $I;
   printf "   double theta%dmed\;\n", $I;
   $I++;
   }

print "   /* Left equatorial vertices */\n";
$I = 1;
while ($I <= $HALFFREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      print "   double phi$I$J";
      print "a\;\n";
      print "   double theta$I$J";
      print "a\;\n";
      $J++;
      } # declare left equatorial doubles by col (0 - row)
   $I++;
   } # declare left equatorial doubles by row (0 - halffreq)
print "   /* Central equatorial vertices */\n";
$I = $FREQ - $HALFFREQ;
while ($I <= $FREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      print "   double phi$I$J";
      print "b\;\n";
      print "   double theta$I$J";
      print "b\;\n";
      $J++;
      } # declare left equatorial doubles by col (0 - row)
   $I++;
   } # declare left equatorial doubles by row (0 - halffreq)
print "   /* Declare geodesic math functions. */\n";
print "   /* Equation 12.4 */\n";
print "   double getx()\;\n";
print "   /* Equation 12.5 */\n";
print "   double gety()\;\n";
print "   /* Equation 12.6 */\n";
print "   double getz()\;\n";
print "   /* Equation 12.7 */\n";
print "   double getphi()\;\n";
print "   /* Equation 12.8 */\n";
print "   double gettheta()\;\n";
print "   /* Equations 12.4, 12.5, 12.6, 12.7 */\n";
print "   double calcphi()\;\n";
print "   /* Equations 12.4, 12.5, 12.6, 12.8 */\n";
print "   double calctheta()\;\n";
print "   /* Equation 9.2 */\n";
print "   double getdist()\;\n";
print "   /* Equation 14.1 */\n";
print "   double rottheta()\;\n";
print "   /* Equation 14.2 */\n";
print "   double rotphi()\;\n";
print "   /* Initialize constants */\n";
print "   freq = $FREQ\;\n";
print "   d180 = 180.0\;\n";
print "   d2r = D2R\;\n";
print "   r2d = R2D\;\n";
$I = 0;
while ($I <= $FREQ)
   {
   print "   d$I = $I.0\;\n";
   $I++;
   }
if ($FREQ < 5)
   {
   print "   d5 = 5.0\;\n";
   }
print "   dblfreq = freq * d2\;\n";
print "   hlffreq = freq / d2\;\n";
print "   d36    = 36.0\;\n";
print "   rad36  = d36  * d2r\;\n";
print "   d144   = 144.0\;\n";
print "   rad144 = d144 * d2r\;\n";
$I = 0;
while ($I <= $FREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      $Y = $I - $J;
      $X = $I - $Y;
      $Z = $FREQ - $X - $Y;
      print "   /* I = Row = $I */\n";
      print "   /* J = Col = $J */\n";
      print "   /* X = $X */\n";
      print "   /* Y = $Y */\n";
      print "   /* Z = $Z */\n";
      print "   phi$I$J   = calcphi(d$X,d$Y)\;\n";
      print "   theta$I$J = calctheta(";
      print "d$X,d$Y,d$Z,freq)\;\n";
      $J++;
      } # y: calculate by col (0 - 72 deg)
   $I++;
   } # x: calculate by row (0 - rowct)

print "   /* Left equatorial triangle */\n";
$I = 1;
while ($I <= $HALFFREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      $Y = $I - $J;
      $X = $I - $Y;
      $Z = $FREQ - $X - $Y;
      print "   /* I = Row = $I */\n";
      print "   /* J = Col = $J */\n";
      print "   /* X = $X */\n";
      print "   /* Y = $Y */\n";
      print "   /* Z = $Z */\n";
      print "   theta$I$J";
      print "a = rottheta(phi$FREQ$FREQ+rad144,";
      print "theta$FREQ$FREQ,phi$I$J,theta$I$J)\;\n";
      print "   phi$I$J";
      print "a   = rotphi(phi$FREQ$FREQ+rad144,";
      print "phi$I$J,theta$I$J,theta$I$J";
      print "a)\;\n";
      $J++;
      } # y: calculate by col (0 - 72 deg)
   $I++;
   } # x: calculate by row (0 - rowct)

print "   /* truncate the dome at the equator */\n";
$I = $HALFFREQ; 
$J = 1;
while ($J < $HALFFREQ)
   {
   printf "   theta$I%da = theta$I%da\;\n", $J, 0; 
   $J++;
   }

printf "   /* Central equatorial triangle */\n";

$DBLFREQ = $FREQ + $FREQ;
$I = $DBLFREQ;
$J = $FREQ;
$Y = $I - $J;
$X = $I - $Y;
$Z = $DBLFREQ - $X - $Y;
print "   /* I = Row = $I */\n";
print "   /* J = Col = $J */\n";
print "   /* X = $X */\n";
print "   /* Y = $Y */\n";
print "   /* Z = $Z */\n";
printf "   phi%dmed   = calcphi(d%d,d%d)\;\n", $J, $X, $Y;
printf "   theta%dmed = calctheta(", $J;
printf "d%d,d%d,d%d,dblfreq)\;\n", $X, $Y, $Z;

$I = $FREQ;
while ($I >= $FREQ - $HALFFREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      $Y = $I - $J;
      $X = $I - $Y;
      $Z = $FREQ - $X - $Y;
      print "   /* I = Row = $I */\n";
      print "   /* J = Col = $J */\n";
      print "   /* X = $X */\n";
      print "   /* Y = $Y */\n";
      print "   /* Z = $Z */\n";
      print "   theta$I$J";
      printf "b = rottheta(phi%dmed,", $FREQ;
      printf "theta%dmed+theta%dmed,", $FREQ, $FREQ;
      print "phi$I$J,theta$I$J)\;\n";
      print "   phi$I$J";
      print "b   = rad36 - ";
      printf "rotphi(phi%dmed,", $FREQ;
      print "phi$I$J,theta$I$J,theta$I$J";
      print "b)\;\n";
      $J++;
      } # y: calculate by col (0 - 72 deg)
   $I--;
   } # x: calculate by row (0 - rowct)

print "   /* truncate the dome at the equator */\n";
$I = $FREQ - $HALFFREQ; 
$J = 1;
while ($J < $I)
   {
   printf "   theta$I%db = theta$I%db\;\n", $J, 0; 
   $J++;
   }

print "   printf(\"Class I Icosahedron, %.0f Frequency\\n\\n\",\n";
print "      freq)\;\n";
print "   printf(\"Icosacap Triangle\\n\")\;\n";
print "   printf(\"Vertex Coordinates\\n\")\;\n";
print "   printf(\"0,0 %20.15f, %20.15f\\n\", d0, d0)\;\n";
$I = 1;
while ($I <= $FREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      print "   phideg   = phi$I$J * r2d\;\n";
      print "   thetadeg = theta$I$J * r2d\;\n";
      print "   printf(\"$I,$J %20.15f, %20.15f\\n\",";
      print " phideg, thetadeg)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 72 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)

printf "   printf(\"Left equatorial triangle\\n\")\;\n";

$I = 1;
while ($I <= $HALFFREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      print "   phideg   = phi$I$J";
      print "a   * r2d\;\n";
      print "   thetadeg = theta$I$J";
      print "a * r2d\;\n";
      print "   printf(\"$I,$J %20.15f, %20.15f\\n\",";
      print " phideg, thetadeg)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 72 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)

printf "   printf(\"Central equatorial triangle\\n\")\;\n";

$I = $FREQ - $HALFFREQ;
while ($I <= $FREQ)
   {
   $J = 0;
   while ($J <= $I)
      {
      print "   phideg   = phi$I$J";
      print "b   * r2d\;\n";
      print "   thetadeg = theta$I$J";
      print "b * r2d\;\n";
      print "   printf(\"$I,$J %20.15f, %20.15f\\n\",";
      print " phideg, thetadeg)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 72 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)

print "   printf(\"\\nIcosacap Triangle\\n\")\;\n";
print "   printf(\"Chord Lengths, Radius = 1\\n\")\;\n";
print "   dist = getdist(d0, d0,";
print " phi10,theta10)\;\n";
print "   printf(\"0,0 - 1,0";
print " %20.15f\\n\", dist)\;\n";
print "   dist = getdist(d0,d0,";
print " phi11,theta11)\;\n";
print "   printf(\"0,0 - 1,1";
print " %20.15f\\n\", dist)\;\n";
print "   dist = getdist(phi10,theta10,";
print " phi11,theta11)\;\n";
print "   printf(\"1,0 - 1,1";
print " %20.15f\\n\", dist)\;\n";
$I = 1;
$BOT = $FREQ - 1;
while ($I <= $BOT)
   {
   $J = 0;
   while ($J <= $I)
      {
      $K = $I + 1;
      $L = $J + 1;
      print "   /* I = $I this row */\n";
      print "   /* J = $J column this row */\n";
      print "   /* K = $K next row */\n";
      print "   /* L = $L next column next row */\n";
      print "   dist = getdist(phi$I$J,theta$I$J,";
      print " phi$K$J,theta$K$J)\;\n";
      print "   printf(\"$I,$J - $K,$J";
      print " %20.15f\\n\", dist)\;\n";
      print "   dist = getdist(phi$I$J,theta$I$J,";
      print " phi$K$L,theta$K$L)\;\n";
      print "   printf(\"$I,$J - $K,$L";
      print " %20.15f\\n\", dist)\;\n";
      print "   dist = getdist(phi$K$J,theta$K$J,";
      print " phi$K$L,theta$K$L)\;\n";
      print "   printf(\"$K,$J - $K,$L";
      print " %20.15f\\n\", dist)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 72 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)

print "   printf(\"Left equatorial triangle\\n\")\;\n";

print "   dist = getdist(phi$FREQ";
print "0,theta$FREQ";
print "0,phi10";
print "a,theta10";
print "a)\;\n";
print "   printf(\"$FREQ,0 - 1,0";
print " %20.15f\\n\", dist)\;\n";
print "   dist = getdist(phi$FREQ";
print "0,theta$FREQ";
print "0,phi11";
print "a,theta11";
print "a)\;\n";
print "   printf(\"$FREQ,0 - 1,1";
print " %20.15f\\n\", dist)\;\n";
print "   dist = getdist(phi10";
print "a,theta10";
print "a,phi11";
print "a,theta11";
print "a)\;\n";
print "   printf(\"1,0 - 1,1";
print " %20.15f\\n\", dist)\;\n";

$I = 1;
$BOT = $HALFFREQ - 1;
while ($I <= $BOT)
   {
   $J = 0;
   while ($J <= $I)
      {
      $K = $I + 1;
      $L = $J + 1;
      print "   /* I = $I this row */\n";
      print "   /* J = $J column this row */\n";
      print "   /* K = $K next row */\n";
      print "   /* L = $L next column next row */\n";
      print "   dist = getdist(phi$I$J";
      print "a,theta$I$J";
      print "a,phi$K$J";
      print "a,theta$K$J";
      print "a)\;\n";
      print "   printf(\"$I,$J - $K,$J";
      print " %20.15f\\n\", dist)\;\n";
      print "   dist = getdist(phi$I$J";
      print "a,theta$I$J";
      print "a,phi$K$L";
      print "a,theta$K$L";
      print "a)\;\n";
      print "   printf(\"$I,$J - $K,$L";
      print " %20.15f\\n\", dist)\;\n";
      print "   dist = getdist(phi$K$J";
      print "a,theta$K$J";
      print "a,phi$K$L";
      print "a,theta$K$L";
      print "a)\;\n";
      print "   printf(\"$K,$J - $K,$L";
      print " %20.15f\\n\", dist)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 72 deg)
   $I++;
   } # x: print vertexia by row (0 - rowct)

print "   printf(\"Central equatorial triangle\\n\")\;\n";

$I = 0;
while ($I < $FREQ)
   {
   $J = $I + 1;
   $K = $FREQ - 1;
   print "   /* I = $I this column next row */\n";
   print "   /* J = $J next column next row */\n";
   print "   /* K = $K next row */\n";
   print "   dist = getdist(phi$FREQ$I,theta$FREQ$I,";
   print " phi$K$I";
   print "b,theta$K$I";
   print "b)\;\n";
   print "   printf(\"$FREQ,$I - $K,$I";
   print " %20.15f\\n\", dist)\;\n";
   print "   dist = getdist(phi$FREQ$J,theta$FREQ$J,";
   print " phi$K$I";
   print "b,theta$K$I";
   print "b)\;\n";
   print "   printf(\"$FREQ,$J - $K,$I";
   print " %20.15f\\n\", dist)\;\n";
   print "   dist = getdist(phi$FREQ$I,theta$FREQ$I,";
   print " phi$FREQ$J,theta$FREQ$J)\;\n";
   print "   printf(\"$FREQ,$I - $FREQ,$J";
   print " %20.15f\\n\", dist)\;\n";
   $I++;
   }

$I = $FREQ - 1;
while ($I > $HALFFREQ)
   {
   $J = 0;
   while ($J < $I)
      {
      $K = $I - 1;
      $L = $J + 1;
      print "   /* I = $I this row */\n";
      print "   /* J = $J column this row */\n";
      print "   /* K = $K next row */\n";
      print "   /* L = $L next column this row */\n";

      print "   dist = getdist(phi$I$J";
      print "b,theta$I$J";
      print "b,phi$K$J";
      print "b,theta$K$J";
      print "b)\;\n";
      print "   printf(\"$I,$J - $K,$J";
      print " %20.15f\\n\", dist)\;\n";

      print "   dist = getdist(phi$I$L";
      print "b,theta$I$L";
      print "b,phi$K$J";
      print "b,theta$K$J";
      print "b)\;\n";
      print "   printf(\"$I,$L - $K,$J";
      print " %20.15f\\n\", dist)\;\n";

      print "   dist = getdist(phi$I$J";
      print "b,theta$I$J";
      print "b,phi$I$L";
      print "b,theta$I$L";
      print "b)\;\n";
      print "   printf(\"$I,$J - $I,$L";
      print " %20.15f\\n\", dist)\;\n";
      $J++;
      } # y: print vertexia by col (0 - 72 deg)
   $I--;
   } # x: print vertexia by row (0 - rowct)

print "   /* Central equatorial strut distance */\n";

$I = 0;
while ($I < $HALFFREQ)
   {
   $J = $I + 1;
   print "   /* I = $I this column next row */\n";
   print "   /* J = $J next column next row */\n";
   print "   dist = getdist(phi$HALFFREQ$I";
   print "b,theta$HALFFREQ$I";
   print "b,phi$HALFFREQ$J";
   print "b,theta$HALFFREQ$J";
   print "b)\;\n";
   print "   printf(\"$HALFFREQ,$I - $HALFFREQ,$J";
   print " %20.15f\\n\", dist)\;\n";
   $I++;
   }
print "   return(0)\;\n";
print "   }\n";
