# This is a perl script, but we invoke it with perl explicitly, so
# no #! line.

# Write the spec file for fungimol's rpm.
# Following the maximum-rpm.ps document.

$version = $ARGV[0]
    || die "A version number must be specified on the command line";

$dochome = $ARGV[1]
    || die "The document home must be specified as the second argument.";

$installhome = $ARGV[2]
    || die "The installation home must be specified as the third argument.";

$includehome = $ARGV[3]
    || die "The include home must be specified as the fourth argument.";

$splinehome = $ARGV[4]
    || die "The spline data file home must be specified as the fifth argument.";

print << "EOM";
#
# Spec file for fungimol.
#
Summary: An extensible system for designing atomic-scale objects.
Name: fungimol
Version: $version
Release: 0
Copyright: LGPL (GNU Library General Public License)
Group: Applications/Engineering
Source: http://www.infoscreen.com/fungimol/fungimol-$version.tar.gz
URL: http://www.infoscreen.com/fungimol/index.html
Packager: Tim Freeman <tim\@infoscreen.com>

%description
The intent is to eventually extend it to be a useful system for
doing molecular nanotechnology design work.  At the moment it's a
PDB file viewer and Buckminsterfullerine editor.

Donald Brenner's Fortran molecular dynamics package is also included.

%prep
%setup

%build
make fullbuild

%install
make install

%files
%doc $dochome
$installhome/fungimol
$includehome
$installhome/brennermd
$splinehome
EOM
