# Fungimol - an extensible system for designing atomic-scale objects.
# Copyright (C) 2000 Tim Freeman
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library in the file COPYING.txt; if not,
# write to the Free Software Foundation, Inc., 59 Temple Place -
# Suite 330, Boston, MA 02111-1307, USA
#
# The author can be reached by email at tim@infoscreen.com, or by
# paper mail at:
#
# Tim Freeman
# 655 S. FairOaks Ave., Apt B-316
# Sunnyvale, CA 94086
#

# Next one is always good, but is not the default.  See the Gnu make document.
.DELETE_ON_ERROR:
# If the current directory is /foo/bar/baz, next line sets PKGNAME to baz.
PKGNAME:=$(shell pwd | perl -pe "s@^.*/@@")
SOURCES:=$(wildcard *.cpp)
ifdef NDEBUG
   OFLAGS:=-DNDEBUG
   SUBDIR_PREFIX:=nodebug
else
   SUBDIR_PREFIX:=debug
endif
SUBDIR:=$(SUBDIR_PREFIX)
OFLAGS += -DTRY_MIT_SHM
# In theory double buffering would be very nice, but unfortunately the XFree86
# implementation doesn't wait for the vertical refresh, so it is not a win.
# Use noship/swaptest.cpp to check if this heals once I get a new X version.
#OFLAGS += -DTRY_DBE
ifeq ($(wildcard $(SUBDIR)/.),)
   JUNK:=$(shell mkdir $(SUBDIR))
endif
ifdef GPROF
   OFLAGS += -pg
endif
ifdef GCOV
   OFLAGS += -fprofile-arcs -ftest-coverage
endif
# Don't need different LINKOPTS if we're debugging.  Occasionally I
# want to use a debug version of some system library, but the way to
# get access to those is to compile the debug version and put it on
# LD_LIBRARY_PATH.  The linker doesn't care which it is linked against.
# Need -rdynamic so plugins can find symbols in the executable.
LINKOPTS:=-L/usr/X11R6/lib
# Dynamic linking is better for debugging because the link ought to be faster.
ifdef NDEBUG
   LINKOPTS += -Xlinker -Bstatic
endif
LINKOPTS += -lXext -lX11 -lm -lppm -lpgm -lpbm 
ifdef NDEBUG
   LINKOPTS += -Xlinker -Bdynamic
endif
LINKOPTS += -ldl -rdynamic
#JUNK:=$(shell echo "Remember to go back to static xlib!" > /dev/tty)
#LINKOPTS:= -Xlinker -Bstatic -L/usr/X11R6/lib -L/usr/src/RPM/BUILD/XFree86-3.3.5/xc/lib/X11 -lXext -lX11 -lm -lppm -lpgm -lpbm -Xlinker -Bdynamic -ldl -rdynamic
ifdef NDEBUG
   # -fomit-frame-pointer only works if we do not do any excpetion handling,
   # which we don't, so it works for us.  Saves 6%.
   # Consider using -fargument-noalias-global; it's simply wrong from
   # a C++ standard point of view, but it probably won't cause any
   # bugs.  Doesn't seem to help. 
   # -fstrict-aliasing is experimental.  Apparently doesn't help.
   # -fstructure-noalias is experimental too.  Doesn't seem to help.
   # -malign-double causes us to have a different memory layout from
   # the iostreams library, which is very bad.  Don't use it.
   # Probably don't want -march=pentiumpro, for portability.
   # I don't understand the portability consequences of
   # -mwide-multiply, so leave it out.
   OFLAGS += -O3 -mcpu=pentiumpro -ffast-math -fomit-frame-pointer -fno-exceptions -s
   #JUNK:=$(shell echo Remember to turn -fomit-frame-pointer back on. > /dev/tty)
   #OFLAGS += -g -O3 -march=pentiumpro -mwide-multiply -ffast-math -fno-exceptions
   # -lglut needs -lXmu.
   # If we're doing mesa, then we need -lXext.
   #LINKOPTS=-L/usr/X11R6/lib -lglut -lMesaGLU -l$(OPENGL) -lXt -lXi -lXmu -lXext -lX11 -lm
   #JUNK:=$(shell echo Remember to take out debug libio. > /dev/tty)
   #LINKOPTS:=-L/usr/src/RPM/BUILD/pgcc-1.1.3/libio -lio -liostream $(LINKOPTS)
else
   # Pass -fno-exceptions during debug build if it's there during
   # optimized builds, so I catch subconscious throw's early.
   # Hope that -fno-inline and -O0 will make the debugger less flakey.
   OFLAGS += -g -fno-exceptions -fno-inline -O0
   # -lglut needs -lXmu.
   # If we're doing mesa, then we need -lXext.
   #LINKOPTS=-L/usr/src/RPM/BUILD/XFree86-3.3.5/xc/lib/X11 -L/usr/X11R6/lib -lglut -lMesaGLU -l$(OPENGL) -lXt -lXi -lXmu -lXext -lX11 -lm -lmcheck
endif
# Is there any reason not to have -felide-constructors?  Why didn't
# they make it the default?
# -Winline is very good.
# Took off -fpic because now we statically link.
ifeq ($(VERSION),)
   VERSION:=Bogus
endif
COPTS=-Wall -Winline -W -Wwrite-strings -Werror -pipe -felide-constructors \
 $(OFLAGS) -I. \
 '-DEXEHOME="$(EXEHOME)"' '-DDOCHOME="$(DOCHOME)"' '-DVERSION="$(VERSION)"'
COPTS+=$(foreach dir,$(USES_PACKAGES),-I$(SYSHOME)/$(dir))
# Some sort of preprocessor hack seems to be called for here to ensure
# that calls to "new" as opposed to NEW(...) will generate errors.
CC=g++ $(COPTS)
# If we have the full pathname in the argument to g++, then emacs can
# parse the error messages without asking what directory each source
# file is in.
# If you want explanations of why it's recompiling stuff, comment in
# the echo.
$(SUBDIR)/%.o: %.cpp
	$(QUIET)#echo Recompiling $< because of $?
	$(CC) -c $(SYSHOME)/$(PKGNAME)/$< -o $@

ifdef DEP
   # Used to call ".dep" files ".d".  This is a bad thing, since it could
   # lead to overwriting or deleteing Brenner's data files ending in
   # ".d" that define his splines. 
   # If a .dep file includes a nonexistent file, that can kill us before we
   # get around to recomputing the .dep files.  Therefore, if there's a
   # problem with the .dep files, delete them all now.

   ifndef DCHECK
      ifneq ($(wildcard *.dep),)
         JUNK:=$(shell $(MAKE) DEP=yes DCHECK=yes *.dep 2>&1 > /dev/null || rm *.dep)
      endif
   endif

   # The next few lines are derived from "Automatic Dependencies" section
   # of the GNU make
   # document.
   #
   # Use /bin/csh instead of $(SHELL) because /bin/sh doesn't detect
   # errors on pipes.  For instance: 
   #
   #[tim@infoscreen Transform]$ /bin/sh -ec 'cat /ugga/bugga | cat'
   #cat: /ugga/bugga: No such file or directory
   #[tim@infoscreen Transform]$ echo $status
   #0
   # Want -f option to /bin/csh so we aren't vulerable to random junk in
   # the .cshrc file.
   %.dep: %.cpp
	$(QUIET)/bin/csh -fec '$(CC) -MM $(CPPFLAGS) $< \
	   | sed '\''s,\($*\)\.o[ :]*,debug/\1.o nodebug/\1.o $@ : ,g'\'' > $@'
   -include $(SOURCES:.cpp=.dep)
endif # ifdef DEP

.PHONY:clean
clean: common_clean
.PHONY: common_clean
common_clean:
	-rm -f {,$(SUBDIR)/}{*.o,*.dep,*~,*.a,*.so,*.bb,*.da,*.gcov,*.bbg,'#'*'#'}
