# Fungimol - an extensible system for designing atomic-scale objects.
# Copyright (C) 2000 Tim Freeman
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library in the file COPYING.txt; if not,
# write to the Free Software Foundation, Inc., 59 Temple Place -
# Suite 330, Boston, MA 02111-1307, USA
#
# The author can be reached by email at tim@infoscreen.com, or by
# paper mail at:
#
# Tim Freeman
# 655 S. FairOaks Ave., Apt B-316
# Sunnyvale, CA 94086
#

include ../mk/home.mk

# Use a recursive make with DEP=yes to do the real work.  We need to
# have .dep files when we do real work, but we don't want to generate
# them for a make clean, so we need to use a recursive make to do the
# real work.
.PHONY:all
all:
	$(QUIET)$(MAKE) real_all DEP=yes

include $(MKROOT)/common.mk

.PHONY:real_all
# Just build .o files, then autoexe.mk picks them up with a wildcard.
#real_all: $(PKGNAME).so
#$(PKGNAME).so: $(SOURCES:.cpp=.o)
#	g++ -shared -o $(PKGNAME).so $(SOURCES:.cpp=.o)
# Have a trivial command on "real_all" so we don't get "Nothing to be done
# for 'real_all'" messages.
real_all: $(foreach file,$(SOURCES:.cpp=.o),$(SUBDIR)/$(file))
	$(QUIET)cat /dev/null

