# Fungimol - an extensible system for designing atomic-scale objects.
# Copyright (C) 2000 Tim Freeman
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library in the file COPYING.txt; if not,
# write to the Free Software Foundation, Inc., 59 Temple Place -
# Suite 330, Boston, MA 02111-1307, USA
#
# The author can be reached by email at tim@infoscreen.com, or by
# paper mail at:
#
# Tim Freeman
# 655 S. FairOaks Ave., Apt B-316
# Sunnyvale, CA 94086
#

# For now, we just support building one executable per package.
include ../mk/home.mk
.PHONY: all

# Have some trivial amount of work to do for "all" so we don't get
# "Nothing to be done for 'all'" messages.
# But don't have a command on "all" because that's reserved for the
# final makefile.
all: 
	$(QUIET)$(MAKE) real_all DEP=yes
include $(MKROOT)/common.mk
.PHONY:real_all
real_all: $(SUBDIR)/$(EXECUTABLE)
	$(QUIET)cat /dev/null

# Statically link in everything, since I like static linking (lets me
# make a stable copy of the program to play with) and since the object
# oriented programming I'm doing obscures the link dependencies, so .a
# files don't work.
#LIBS := $(foreach dir,$(USES_PACKAGES),$(SYSHOME)/$(dir)/$(dir).so)
LIBS := $(foreach dir,$(USES_PACKAGES),$(wildcard $(SYSHOME)/$(dir)/$(SUBDIR)/*.o))
$(SUBDIR)/$(EXECUTABLE): $(foreach file,$(SOURCES:.cpp=.o),$(SUBDIR)/$(file)) $(LIBS)
	@echo Linking $(SUBDIR)/$(EXECUTABLE) because of $?.
	$(CC) -o $(SUBDIR)/$(EXECUTABLE) $^ $(LINKOPTS)
.PHONY:clean
clean: autoexe_clean
.PHONY:autoexe_clean
autoexe_clean:
	-rm -f $(EXECUTABLE) $(SUBDIR)/$(EXECUTABLE)
