use strict;
# This is a perl script, but we invoke it with perl explicitly, so
# no #! line.

# Write the spec file for brennermd's rpm.
# Following the maximum-rpm.ps document.

my ($version) = $ARGV[0]
    || die "A version number must be specified on the command line";

my ($installhome) = $ARGV[1]
    || die "The installation home must be specified as the second argument.";

my ($splinehome) = $ARGV[2]
    || die ("The spline data file home must be specified as the ".
	    "third argument.");

print << "EOM";
#
# Spec file for brennermd.
#
Summary: Molecular dynamics simulations with hydrocarbons.
Name: brennermd
Version: $version
Release: 0
Copyright: Public Domain
Group: Applications/Engineering
Source: http://www.infoscreen.com/fungimol/brennermd-$version.tar.gz
URL: http://www.infoscreen.com/fungimol/index.html
Packager: Tim Freeman <tim\@infoscreen.com>

%description

Fortran code that does molecular dynamics, if all your atoms are
hydrogens and carbons.  The point here is that the algorithm for computing
the forces and energies gives reasonable results even if reactions are
happening, without doing any quantum mechanics.

The original sources are
http://www.engr.ncsu.edu/mat/CompMatSci/MD.tar.Z.  The "Code" section
of the page at http://www.mse.ncsu.edu/CompMatSci has a broken link
that ought to go there.

The changes made by Tim Freeman were bug fixes and getting it to build
under Linux.

%prep
%setup

%build
make fullbuild

%install
make install

%files
$installhome/brennermd
$splinehome

EOM
