// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __XObjectDrawer_h__
#define __XObjectDrawer_h__

#ifndef __ObjectDrawer_h__
#include "ObjectDrawer.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Canvas_h__
#include "Canvas.h"
#endif

class Vec3i;
class BinSet;
class DepthClipInfo;
class XObjectDrawer
  : public ObjectDrawer
{
public:
  // Whether DepthCount is a short or an int doesn't affect the speed of
  // things, it seems.
  typedef short DepthCount;
  // Log to the base 2 of the number of pixels horizontally and vertically in a
  // bin.
  // This is a global constant, rather than being determined from the actual
  // width of the drawn portion of the framebuffer, so we can compute dirty
  // bins one pass earlier than otherwise.
  static const int widthShift = 5;
  // How many units of depth we make room for.
  static const int clipBufDepthShift = 6;
  static const int clipBufDepth = 1 << clipBufDepthShift;
  // We'll look at 64 bins wide by 64 bins deep.  Since we have 32
  // pixels per bin, this is enough to accomodate a 2048x2048 pixel
  // screen.  My screen is 1280 pixels wide, so a 1024 pixel wide
  // screen isn't sufficient.
  // To decrease the amount of stuff to pass around, we assume the
  // width equals the height.
  static const int clipBufWidthShift = 6;
  static const int clipBufWidth = 1 << clipBufWidthShift;
  // The numbers above multiply out to 0.5MB of depth clip buffer.  We are
  // careful not to touch the parts we don't need, so it doesn't slow
  // us down.

  // Next one aborts; we only support the fancy draw method below.
  void draw (const Float *state, const Canvas *vo, int objectIndex,
	     const SceneGraph *sg) const;
  virtual void draw (const Float *state, const Canvas *vo,
		     const Vec3i &pos,
		     // What we need to update the depth clipping buffer.
		     const DepthClipInfo &buf,
		     // The set of bins that are finished, so we can avoid
		     // trying to draw into them.  (We know that drawing into
		     // them will be completely clipped.)
		     const BinSet &finished,
		     int objectIndex, const SceneGraph *sg) const = 0;
};

#endif
