// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __ObjectDrawer_h__
#include "ObjectDrawer.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __OneObjectDrawerConfiguration_h__
#include "OneObjectDrawerConfiguration.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __ObjectDrawer_h__
#include "ObjectDrawer.h"
#endif

#ifndef __XObjectDrawer_h__
#include "XObjectDrawer.h"
#endif

#ifndef __BoundingBox_h__
#include "BoundingBox.h"
#endif

#ifndef __BinSet_h__
#include "BinSet.h"
#endif

#ifndef __XNullDrawerFactory_h__
#include "XNullDrawerFactory.h"
#endif

class Vec3i;
class BinSet;

namespace {
  // An object drawer that does nothing.
  class NullDrawer
    : public XObjectDrawer
  {
  public:
    bool intersect (const Float *state,
		    const Vec3 &v1, const Vec3 &v2, Vec3 *result,
		    int objectIndex, const SceneGraph *sg) const;
    bool graphicsIntersect (const Float *state, const BoundingBox &box,
			    int oI, const SceneGraph *sg)
      const;
    bool intersect (const Float *state,
		    const Vec3 &v, int oI, const SceneGraph *sg) const;
    Float graphicsBoundingSphereRadius (int oI, const SceneGraph *sg) const;
    void draw (const Float *state, const Canvas *vo,
	       int oI, const SceneGraph *sg) const;
    void draw (const Float *state, const Canvas *vo, const Vec3i &v,
	       int oI, const SceneGraph *sg)
      const;
    Vec3 boundingSphereCenter (const Float *state) const;
    bool isVisible () const;
    void draw (const Float *state, const Canvas *vo,
	       const Vec3i &pos, const DepthClipInfo &buf, const BinSet &b,
	       int oI, const SceneGraph *sg)
      const;
  };
  
  bool NullDrawer::intersect (const Float *state,
			      const Vec3 &v1, const Vec3 &v2, Vec3 *result,
			      int oI, const SceneGraph *sg)
    const
  {
    (void) state; (void) v1; (void) v2; (void) result;
    (void) oI; (void) sg;
    return false;
  }
  
  bool NullDrawer::graphicsIntersect (const Float *state,
				      const BoundingBox &box,
				      int oI, const SceneGraph *sg)
    const
  {
    (void) state; (void) box; (void) oI; (void) sg;
    return false;
  }
  
  bool NullDrawer::intersect (const Float *state, const Vec3 &v,
			      int objectIndex, const SceneGraph *sg) const {
    (void) state; (void) v; (void) objectIndex; (void) sg;
    return false;
  }
  
  Float NullDrawer::graphicsBoundingSphereRadius (int objectIndex,
						  const SceneGraph *sg) const {
    (void) objectIndex; (void) sg;
     return 0;
   }

   void NullDrawer::draw (const Float *state, const Canvas *vo,
			  int oI, const SceneGraph *sg) const {
     (void) state; (void) vo; (void) oI; (void) sg;
   }

   void NullDrawer::draw (const Float *state, const Canvas *vo,
			  const Vec3i &pos,
			  int oI, const SceneGraph *sg) const
   {
     (void) state; (void) vo; (void) pos; (void) oI; (void) sg;
   }

   Vec3 NullDrawer::boundingSphereCenter (const Float *state) const {
     (void) state;
     return Vec3 (0,0,0);
   }

   bool NullDrawer::isVisible () const {
     return false;
   };

   void NullDrawer::draw (const Float *state, const Canvas *vo,
			  const Vec3i &pos, const DepthClipInfo &buf,
			  const BinSet &b,
			  int oI, const SceneGraph *sg)
     const
   {
     (void) state; (void) vo; (void) pos; (void) buf; (void) b;
     (void) oI; (void) sg;
   }
 }

 XNullDrawerFactory::XNullDrawerFactory (const String &name)
   : Factory ("X"+name+"Drawer")
 {}

 SP<Configuration> XNullDrawerFactory::defaultConfiguration () const {
   return (NEW (OneObjectDrawerConfiguration ()));
 }

 SP<Configurable> XNullDrawerFactory::makeIt (SP<Configuration> c) const {
  OneObjectDrawerConfiguration *conf =
    dynamic_cast <OneObjectDrawerConfiguration *> (&*c);
  assert (conf);
  (void) conf;
  return NEW (NullDrawer ());
}

namespace {
  static const bool useless =
  (FactoryTable::store ("ObjectDrawer", NEW (XNullDrawerFactory ("Null"))),
   true);
}
