#ifndef __XLineDrawer_h__
#define __XLineDrawer_h__

// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __Float_h__
#include "Float.h"
#endif

class Canvas;
class Vec3i;
class DepthClipInfo;
class BinSet;
class Color;
class XLineDrawer {
public:
  static void drawLine (const Canvas *vo, const Vec3i &v1, const Vec3i &v2,
			const Color &color,
			const DepthClipInfo &dci, const BinSet &finished);

  // Next one is like drawLine, except we'll make the line dimmer as
  // it is drawn further away, until a line near the background is faded to
  // backgroundFade times its original value.  backgroundFade should be more
  // than zero (so you can see the line) and less than or equal to 1.
  // The fade is determined by the depth of v1.
  static void drawFadingLine
  (const Canvas *vo, const Vec3i &v1, const Vec3i &v2,
   const Color &color,
   const DepthClipInfo &dci, const BinSet &finished, Float backgroundFade);
};
#endif


