// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __XCanvasConfiguration_h__
#include "XCanvasConfiguration.h"
#endif

#ifndef __BoolSlotValue_h__
#include "BoolSlotValue.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

namespace {
  String shmName () {
    return "Use MIT Shared Memory Extension";
  }
  String dbeName () {
    return "Use double buffering extension";
  }    
}

XCanvasConfiguration::XCanvasConfiguration () {
  const bool shmInit =
#ifdef TRY_MIT_SHM
						  true
#else
						  false
#endif
    ;
  initializeSlot (shmName (), NEW (BoolSlotValue (shmInit)));
  const bool dbeInit =
#ifdef TRY_DBE
						  true
#else
						  false
#endif
    ;
  initializeSlot (dbeName (), NEW (BoolSlotValue (dbeInit)));
}

void XCanvasConfiguration::setUseShm (bool useShm) {
  BoolSlotValue::setSlot (this, shmName (), useShm);
}

bool XCanvasConfiguration::getUseShm () const {
  return BoolSlotValue::getSlot (this, shmName ());
}

void XCanvasConfiguration::setUseDbe (bool useDbe) {
  BoolSlotValue::setSlot (this, dbeName (), useDbe);
}

bool XCanvasConfiguration::getUseDbe () const {
  return BoolSlotValue::getSlot (this, dbeName ());
}

SP<Configuration> XCanvasConfiguration::copy () const {
  return NEW (XCanvasConfiguration (*this));
}

bool XCanvasConfiguration::hasTheSameTypeAs (const Configuration *c) const {
  return 0 != dynamic_cast <const XCanvasConfiguration *> (c);
}
