// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __XCanvas_h__
#define __XCanvas_h__

#ifndef __Canvas_h__
#include "Canvas.h"
#endif

// For XImage, among others.
#ifndef __X11_Xlib_h__
#include "X11/Xlib.h"
#define __X11_Xlib_h__
#endif

class XCanvasConfiguration;
class XCanvas
  : public Canvas
{
  struct XCanvasData;
  XCanvasData *m_data;
public:
  // X-Windows specific stuff.
  void setWidth (int width);
  void setHeight (int height);
  // Why is all this X connection stuff in this class?
  // If we want to do a frame buffer in shared memory, then we need to
  // know what the display is when the window is resized, so we can
  // generate the new frame buffer still in shared memory.
  // We also need to have the XVisualInfo to do this.
  const Display *getDisplay () const;
  Display *getDisplay ();
  // A reference to an Canvas can hang around for longer than
  // I'd like, and it has a lot of data associated with it, so I want
  // to be able to close it explicitly.
  void closeDisplay ();
  XCanvas (XCanvasConfiguration *xcc);
  virtual ~XCanvas ();

  // Generic canvas methods.  See comments in Canvas.h.
  int viewPointChangeCount () const;
  int getWidth () const;
  int getHeight () const;
  void setScale (Float scale);
  Float getScale () const;
  Vec3 transformWorldToLHScreen (const Vec3 &where) const;
  Vec3 transformLHScreenToWorld (const Vec3 &where) const;
  Vec3i iTransformWorldToLHScreen (const Vec3 &where) const;
  Vec3 transformWorldToRHScreen (const Vec3 &where) const;
  Vec3 transformRHScreenToWorld (const Vec3 &where) const;
  Matrix4 transformRHScreenToWorld (const Matrix4 &mat) const;
  Quaternion transformRHScreenToWorld (const Quaternion &q) const;
  Quaternion transformWorldToRHScreen (const Quaternion &q) const;
  BoundingSphere transformRHScreenToWorld (const BoundingSphere &bs)
    const;
  BoundingSphere transformWorldToRHScreen (const BoundingSphere &bs)
    const;
  LongestPixel packColor (const Color &c) const;
  Color unPackColor (LongestPixel p) const;
  int pixelBytes () const;
  void setOrigin (const Vec3 &o);
  Vec3 getOrigin () const;
  void setRotation (const Quaternion &q);
  Quaternion getRotation () const;
  Float getNearPlane () const;
  Float getFarPlane () const;
  void *getFrameBuffer () const;
  int getFrameBufferPixelsPerLine () const;
  Depth *getDepthBuffer () const;
  bool doubleBuffered () const;
  void swapBuffers () const;
  void drawFrame () const;
  void drawRect (const ScreenRect &r) const;
  void sync () const;
  void flush () const;
  void clearFrame () const;
  void clearColorRect (const ScreenRect &r) const;
  void clearDepthRect (const ScreenRect &r, Depth d) const;
};
#endif

