// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __XBallDrawerConfiguration_h__
#include "XBallDrawerConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __BoolSlotValue_h__
#include "BoolSlotValue.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

namespace {
  String watchName () {
    return "Watch the balls render";
  }
}

XBallDrawerConfiguration::XBallDrawerConfiguration () {
  initializeSlot (watchName(), NEW (BoolSlotValue (false)));
}

bool XBallDrawerConfiguration::getWatch () const {
  return BoolSlotValue::getSlot (this, watchName ());
}

void XBallDrawerConfiguration::setWatch (bool v) {
  BoolSlotValue::setSlot (this, watchName (), v);
}

SP<Configuration> XBallDrawerConfiguration::copy () const {
  return NEW (XBallDrawerConfiguration (*this));
}

bool XBallDrawerConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const XBallDrawerConfiguration *> (c);
}
