// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Rect_h__
#define __Rect_h__

// A rectangle.  minx and miny are included.  Maxx and maxy are not included.
// They are one past the end.
#ifndef __Canvas_h__
#include "Canvas.h"
#endif

#ifndef __XObjectDrawer_h__
#include "XObjectDrawer.h"
#endif

#ifndef __FloatUtil_h__
#include "FloatUtil.h"
#endif

#ifndef __DepthClipInfo_h__
#include "DepthClipInfo.h"
#endif

struct Rect {
  int minx; int miny; int maxx; int maxy;
  Rect () {}
  Rect (int a_minx, int a_miny, int a_maxx, int a_maxy)
    : minx (a_minx), miny (a_miny), maxx (a_maxx), maxy (a_maxy)
  {}
  Canvas::ScreenRect screenRect
  (const Canvas *vo,
   const DepthClipInfo &dci) {
    (void) dci; // dci used to have an m_widthShift field we needed.
    const int widthShift = XObjectDrawer::widthShift;
    const int leftx = minx << widthShift;
    const int boty = miny << widthShift;
    const int rightx = FloatUtil::min (maxx << widthShift, vo->getWidth ());
    const int topy = FloatUtil::min (maxy << widthShift, vo->getHeight ());
    return Canvas::ScreenRect (leftx, boty,
				      rightx - leftx, topy - boty);
  }
};

#endif
