// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __VecUtil_h__
#define __VecUtil_h__

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

struct VecUtil {
  // cmpFun says that whether its first argument is less than its second.
  // Sort the vector in place.
  template<class T> static void sort (Dynavec <T> &v, bool (cmpFun) (const T&, const T&)) {
    for (int i = 0; i < v.size(); i++) {
      for (int j = i+1; j < v.size(); j++) {
	if (cmpFun (v [j], v [i])) {
	  T tmp = v [j];
	  v [j] = v [i];
	  v [i] = tmp;
	}
      }
    }
  }
  
  template<class T> static void sort (Dynavec <T> &v) {
    sort (v, operator<);
  }

  // Find the element in the vector and put the result into *result,
  // if result is not null.  In any case, return true if and only if we found
  // it.
  template<class T> static bool find (T elt, const Dynavec <T> &v,
				      int *result = 0) {
    const int s = v.size();
    for (int i = 0; i < s; i++) {
      if (v[i] == elt) {
	if (result) *result = i;
	return true;
      }
    }
    return false;
  }

  template<class T> static bool setEqual (const Dynavec <T> &v1,
					  const Dynavec <T> &v2) {
    {
      const int s = v1.size();
      for (int i = 0; i < s; i++) {
	if (! find (v1[i], v2)) return false;
      }
    }
    {
      const int s = v2.size ();
      for (int i = 0; i < s; i++) {
	if (! find (v2[i], v1)) return false;
      }
    }
    return true;
  }

  template <class T> static bool hasDuplicates (const Dynavec <T> &v) {
    const int s = v.size();
    for (int i = 0; i < s; i++) {
      for (int j = i+1; j < s; j++) {
	if (v[i] == v[j]) return true;
      }
    }
    return false;
  }

  // Remove the element from the vector, considering the vector as a
  // set which will not have duplicates.
  template <class T> static void removeNoDups (const T &elt, Dynavec <T> &v) {
    assert (!hasDuplicates (v));
    int s = v.size ();
    for (int i = 0; i < s; i++) {
      if (elt == v[i]) {
	v[i]=v[v.size()-1];
	v.pop();
	break;
      }
    }
  }

  // Remove the element from the vector, considering the vector as a
  // set which will not have duplicates.
  template <class T> static void remove (const T &elt, Dynavec <T> &v) {
    assert (!hasDuplicates (v));
    for (int i = 0; i < v.size();) {
      if (elt == v[i]) {
	v[i]=v[v.size()-1];
	v.pop();
      } else {
	i++;
      }
    }
  }
};  
#endif
