// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Stopwatch_h__
#define __Stopwatch_h__

#ifndef __sys_timeb_h__
#include <sys/timeb.h>
#define __sys_timeb_h__
#endif

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

class Stopwatch : public Refcount {
  struct timeb buf1;
 public:
  inline Stopwatch () {
    ftime (&buf1);
  }
  inline int millis () {
    struct timeb buf2;
    ftime (&buf2);
    return (buf2.time - buf1.time) * 1000 + buf2.millitm - buf1.millitm;
  }
};
#endif
