// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __MemoryUtil_h__
#define __MemoryUtil_h__

// For size_t.
#ifndef __stddef_h__
#include <stddef.h>
#define __stddef_h__
#endif

// For the time being, let's use the paranoid memory allocator even in
// production code, since the performance doesn't depend on fast memory
// allocation.
// Instead of new int or new int [15], have NEW(int) or NEW (int
// [15]).

// By the way, this file also redefines the global new, so we can do
// memory corruption detection and leak detection on code that can't be
// modified to use NEW instead.

#define NEW(x) new (__LINE__, __FILE__) x
// Gnu's cpp thinks that this code
//    table = NEW (HashTable <String, FactoryList> ()); 
// calls NEW with two arguments. :-(.  Thus you need:
//    table = NEW2 (HashTable <String, FactoryList> ()); 
#define NEW2(x,y) new (__LINE__, __FILE__) x,y
// Sorry, there is only global delete.
void operator delete [] (void *x);
// Tried to put these operator new's into the MemoryUtil struct, but I
// couldn't figure out how to make the NEW/NEW2 macros call them.
void *operator new (size_t size, int line, const char *file);
void *operator new [] (size_t size, int line, const char *file);
struct MemoryUtil {
  // If a file allocates some static stuff and doesn't want that
  // stuff to appear as leaked, it should call registerDeallocator
  // with a function that deletes it.  The callback will be called when
  // listLeaks is called, just before listing the leaks.
  static void registerDeallocator (void (*f) ());
  static void listLeaks ();
  // Check for corrupted memory blocks.
  static void check ();
  // Set this to true to check for corrupted memory blocks on every new and
  // delete.
  static bool frequentCheck;
};
#endif
