// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Hashable_h__
#define __Hashable_h__

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

// Hash tables can take one of these.
class Hashable : public Refcount {
  typedef unsigned int HASH;
 public:
  virtual HASH hash () const = 0;
  // Implementing the next one seems to require a cast.  Yuck.
  virtual bool operator== (const Hashable &s) const = 0;
  // Allocate and return a copy.
  virtual Hashable *copy () const = 0;
};

#endif
