// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __TransformConfiguration_h__
#include "TransformConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __Canvas_h__
#include "Canvas.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __Quaternion_h__
#include "Quaternion.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

namespace {
  class TransformWorldMove
    : public TypedFactory <TransformConfiguration, Action>
  {
  public:
    TransformWorldMove ()
      : TypedFactory <TransformConfiguration, Action> ("TransformWorldMove")
    {}
    SP<TransformConfiguration> typedDefaultConfiguration () const {
      return NEW (TransformConfiguration ());
    }
    SP<Action> makeIt (TransformConfiguration *c) const {
      SP<TopLevel> top = c->getTopLevel();
      SP<SceneGraph> sg = top->getSceneGraph ();
      const SP<Canvas> xvo = top->getCanvas ();
      Vec3 cbScreen = c->getCenter ();
      const Vec3 cbWorld = xvo->transformRHScreenToWorld (cbScreen);
      cbScreen += c->getTranslation ();
      Quaternion worldRot = xvo->getRotation ();
      Quaternion newRot = c->getRotation ();
      worldRot = newRot * worldRot;
      xvo->setRotation (worldRot);
      // Now all we have to do is adjust the origin so that the screen
      // coordinates cbScreen map to cbWorld again.  What world
      // coordinate translates to the cbScreen now?
      const Vec3 cbWorldNow = xvo->transformRHScreenToWorld (cbScreen);
      // The change we have to make to the origin is equal to the cursor
      // ball's actual world position minus cbWorldNow.
      xvo->setOrigin (xvo->getOrigin () + cbWorld - cbWorldNow);
      return NEW (Action ());
    }
    String getPrettyName (const Configuration *c) const {
      (void) c;
      return "change the viewpoint";
    }
  };
  static const bool useless =
  (FactoryTable::store ("TransformAction", NEW (TransformWorldMove ())),
   true);
}
