// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TransformMacroConfiguration_h__
#include "TransformMacroConfiguration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __VectorSlotValue_h__
#include "VectorSlotValue.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

namespace {
  String commandsName () {
    return "Commands";
  }
}

TransformMacroConfiguration::TransformMacroConfiguration () {
  initializeSlot (commandsName (),
		  NEW (VectorSlotValue
		       (NEW (RecursiveSlotValue ("TransformAction",
						 "DoNothing")))));
}

SP<const VectorSlotValue> TransformMacroConfiguration::getCommandVector () const {
  return VectorSlotValue::getSlotValue (this, commandsName ());
}

SP<VectorSlotValue> TransformMacroConfiguration::getCommandVector () {
  return VectorSlotValue::getSlotValue (this, commandsName ());
}

void TransformMacroConfiguration::setCommandVector (VectorSlotValue *vsv) {
  VectorSlotValue::setSlotValue (this, commandsName (), vsv);
}

void TransformMacroConfiguration::setCommandVector
(const Dynavec <SP<RecursiveSlotValue> > &v)
{
  Dynavec <SP <SlotValue> > vv;
  for (int i = 0; i < v.size(); i++) {
    vv.push (&*v[i]);
  }
  VectorSlotValue::setSlotValue (this, commandsName (),
				 NEW (VectorSlotValue
				      (NEW (RecursiveSlotValue
					    ("TransformAction",
					     "DoNothing")),
				       vv)));
}

SP<Configuration> TransformMacroConfiguration::copy () const {
  return NEW (TransformMacroConfiguration (*this));
}

bool TransformMacroConfiguration::hasTheSameTypeAs
(const Configuration *c) const
{
  return 0 != dynamic_cast <const TransformMacroConfiguration *> (c);
}
