// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TransformMacro_h__
#include "TransformMacro.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __TransformMacroConfiguration_h__
#include "TransformMacroConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __VectorSlotValue_h__
#include "VectorSlotValue.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __Quaternion_h__
#include "Quaternion.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

TransformMacro::TransformMacro ()
  : TypedFactory <TransformMacroConfiguration, Action> ("TransformMacro")
{}

SP<TransformMacroConfiguration> TransformMacro::typedDefaultConfiguration () const
{
  return NEW (TransformMacroConfiguration ());
}

SP<Action> TransformMacro::makeIt (TransformMacroConfiguration *mc) const {
  SP<VectorSlotValue> vsv = mc->getCommandVector ();
  for (int i = 0; i < vsv->size(); i++) {
    SP<RecursiveSlotValue> rsv =
      dynamic_cast <RecursiveSlotValue *> (&*((*vsv)[i]));
    assert (rsv);
    SP<TransformConfiguration> ac =
      dynamic_cast <TransformConfiguration *> (&*rsv->getConfiguration ());
    assert (ac);
    ac->setTopLevel (mc->getTopLevel());
    ac->setTranslation (mc->getTranslation ());
    ac->setCenter (mc->getCenter ());
    ac->setRotation (mc->getRotation ());
    SP<Configurable> result = rsv->makeIt ();
    assert (result);
    SP<Action> action = dynamic_cast <Action *> (&*result);
    if (action->isProblem ()) {
      return action;
    }
  }
  return NEW (Action ());
}

String TransformMacro::getPrettyName (const Configuration *c) const {
  SP<const TransformMacroConfiguration> mc =
    dynamic_cast <const TransformMacroConfiguration *> (c);
  assert (mc);
  SP<const VectorSlotValue> vsv = mc->getCommandVector ();
  String result;
  if (0 == vsv->size()) {
    result = "a do-nothing macro";
  } else {
    result = (*vsv)[0]->unParse ();
    for (int i = 1; i < vsv->size(); i++) {
      result += " and "+(*vsv) [i]->unParse ();
    }
  }
  return result;
}

SP<RecursiveSlotValue> TransformMacro::mkMacro
(const Dynavec <SP<RecursiveSlotValue> > &rsv) {
  SP<RecursiveSlotValue> result =
    NEW (RecursiveSlotValue ("TransformAction", "TransformMacro"));
  SP<TransformMacroConfiguration> mc = NEW (TransformMacroConfiguration ());
  mc->setCommandVector (rsv);
  result->setConfiguration (&*mc);
  return result;
}

SP<RecursiveSlotValue> TransformMacro::mkMacro (const Dynavec <String> &names)
{
  Dynavec <SP<RecursiveSlotValue> > rsvs;
  for (int i = 0; i < names.size(); i++) {
    rsvs.push (NEW (RecursiveSlotValue ("TransformAction", names[i])));
  }
  return mkMacro (rsvs);
}

namespace {
  bool useless = (FactoryTable::store ("TransformAction",
				       NEW (TransformMacro ())),
		  true);
}
