// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AnyMouseXYZMoveConfiguration_h__
#define __AnyMouseXYZMoveConfiguration_h__

#ifndef __OuterTransformConfiguration_h__
#include "OuterTransformConfiguration.h"
#endif

#ifndef __Event_h__
#include "Event.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class Configuration;
class AnyMouseXYZMoveConfiguration
  : public OuterTransformConfiguration
{
  // Where on the screen the mouse was last observed.
  int m_x;
  int m_y;
public:
  AnyMouseXYZMoveConfiguration ();
  // You can configure which shift key will give you the XZ motion.
  Event::Button getShift () const; 
  void setShift (Event::Button b);
  int getX () const;
  int getY () const;
  void setX (int x);
  void setY (int y);
  SP<Configuration> copy () const  ;
  bool hasTheSameTypeAs (const Configuration *c) const;
};
#endif
