// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AnyMouseXYZMoveConfiguration_h__
#include "AnyMouseXYZMoveConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __ButtonSlotValue_h__
#include "ButtonSlotValue.h"
#endif

#ifndef __KeyboardMouseEvent_h__
#include "KeyboardMouseEvent.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

namespace {
  String shiftKeyName () {
    return "Shift key";
  }
}

typedef Event::Button Button;

AnyMouseXYZMoveConfiguration::AnyMouseXYZMoveConfiguration ()
{
  initializeSlot (shiftKeyName (),
		  NEW (ButtonSlotValue (NEW (KeyboardMouseEvent()),
					KeyboardMouseEvent::SHIFT)));
}

Button AnyMouseXYZMoveConfiguration::getShift () const {
  return ButtonSlotValue::getSlot (this, shiftKeyName());
}
  
void AnyMouseXYZMoveConfiguration::setShift (Button b) {
  ButtonSlotValue::setSlot (this, shiftKeyName(), b);
}
  
int AnyMouseXYZMoveConfiguration::getX () const {
  return m_x;
}

int AnyMouseXYZMoveConfiguration::getY () const {
  return m_y;
}

void AnyMouseXYZMoveConfiguration::setX (int x) {
  m_x = x;
}

void AnyMouseXYZMoveConfiguration::setY (int y) {
  m_y = y;
}

SP<Configuration> AnyMouseXYZMoveConfiguration::copy () const {
  return NEW (AnyMouseXYZMoveConfiguration (*this));
}
  
bool AnyMouseXYZMoveConfiguration::hasTheSameTypeAs
(const Configuration *c) const
{
  return 0 != dynamic_cast <const AnyMouseXYZMoveConfiguration *> (c);
}
