// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AnyMouseXYZMove_h__
#define __AnyMouseXYZMove_h__

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __AnyMouseXYZMoveConfiguration_h__
#include "AnyMouseXYZMoveConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class String;
class RecursiveSlotValue;
class AnyMouseXYZMove
  : public TypedFactory <AnyMouseXYZMoveConfiguration, Action>
{
public:
  AnyMouseXYZMove ();
  SP<AnyMouseXYZMoveConfiguration> typedDefaultConfiguration () const;
  String getPrettyName (const Configuration *c) const;
  SP<Action> makeIt (AnyMouseXYZMoveConfiguration *cbac) const;
  // Hmm, the next two don't let you set the shift key to anything but the
  // default.  Add an optional argument later if there is a perceived need.
  static SP<RecursiveSlotValue> mkMouseXYZMove (RecursiveSlotValue *slot);
  static SP<RecursiveSlotValue> mkMouseXYZMove (const String &name);
};
#endif
