// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AnyMouseXYZMove_h__
#include "AnyMouseXYZMove.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __AnyMouseXYZMoveConfiguration_h__
#include "AnyMouseXYZMoveConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __KeyboardMouseEvent_h__
#include "KeyboardMouseEvent.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __TransformConfiguration_h__
#include "TransformConfiguration.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

AnyMouseXYZMove::AnyMouseXYZMove ()
  : TypedFactory <AnyMouseXYZMoveConfiguration, Action> ("AnyMouseXYZMove")
{}

SP<AnyMouseXYZMoveConfiguration> AnyMouseXYZMove::typedDefaultConfiguration () const {
  return NEW (AnyMouseXYZMoveConfiguration ());
}

String AnyMouseXYZMove::getPrettyName (const Configuration *c) const {
  SP<const AnyMouseXYZMoveConfiguration> conf =
    dynamic_cast <const AnyMouseXYZMoveConfiguration *> (c);
  assert (conf);
  return "Use the mouse to " + conf->getTransformAction()->unParse();
}

SP<Action> AnyMouseXYZMove::makeIt (AnyMouseXYZMoveConfiguration *conf) const {
  SP<TopLevel> top = conf->getTopLevel ();
  SP<const KeyboardMouseEvent> e =
    dynamic_cast <const KeyboardMouseEvent *> (&*top->getEvent());
  assert (e);
  const int oldX = conf->getX();
  const int oldY = conf->getY();
  const int x = e->getX();
  const int y = e->getY();
  conf->setX (x);
  conf->setY (y);
  SP<Action> result = NEW (Action ());
  if (conf->isFirst ()) {
    if (e->getButton () == e->pointerMotionButton ()) {
      // The problem here is that this action looks at changes to the mouse
      // position to decide what to do.  We can't grab the mouse if we're
      // bound to pointer motion because then no other commands can run, and we
      // can't observe changes to the mouse position if we can't grab the
      // mouse.
      result->setProblem ("It does not make sense to bind AnyMouseXYZMove "
			  "to pointer motion");
    } else {
      SelectionManager::setSelectionBlink (false);
      conf->grabIfFirst (this);
    }
  } else {
    if (conf->isLast ()) {
      SelectionManager::setSelectionBlink (true);
    }
    if (e->getButton() == e->pointerMotionButton ()) {
      const int dx = x - oldX;
      const int dy = y - oldY;
      SP<RecursiveSlotValue> rsv = conf->getTransformAction();
      SP<TransformConfiguration> tc =
	dynamic_cast <TransformConfiguration *> (&*rsv->getConfiguration());
      assert (tc);
      if (e->isButtonDown (conf->getShift ())) {
	// XZ motion.  Moving the mouse up should push the object away from
	// you.
	tc->setTranslation (Vec3 (dx, 0, -dy));
      } else {
	// XY motion.
	tc->setTranslation (Vec3 (dx, dy, 0));
      }
      tc->setTopLevel (top);
      result = dynamic_cast <Action *> (&*rsv->makeIt());
      assert (result);
    }
  }
  if (result->isProblem ()) {
    SelectionManager::setSelectionBlink (true);
  }
  return result;
}

namespace {
  static const bool useless =
  (FactoryTable::store ("KeyboardMouseAction", NEW (AnyMouseXYZMove ())),
   true);
}

SP<RecursiveSlotValue> AnyMouseXYZMove::mkMouseXYZMove
(RecursiveSlotValue *slot)
{
  SP<AnyMouseXYZMoveConfiguration> conf =
    NEW (AnyMouseXYZMoveConfiguration ());
  conf->setTransformAction (slot);
  SP<RecursiveSlotValue> rsv = NEW (RecursiveSlotValue ("KeyboardMouseAction",
							"AnyMouseXYZMove"));
  rsv->setConfiguration (&*conf);
  return rsv;
}

SP<RecursiveSlotValue> AnyMouseXYZMove::mkMouseXYZMove (const String &name) {
  return mkMouseXYZMove (NEW (RecursiveSlotValue ("TransformAction", name)));
}
