// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AnyMouseTrackballConfiguration_h__
#define __AnyMouseTrackballConfiguration_h__

#ifndef __OuterTransformConfiguration_h__
#include "OuterTransformConfiguration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

class Configuration;
class AnyMouseTrackballConfiguration
  : public OuterTransformConfiguration
{
  // Where on the screen the mouse was last observed.
  int m_x;
  int m_y;
public:
  AnyMouseTrackballConfiguration ();
  // You can configure the radius of the virtual trackball.  Smaller trackballs
  // rotate things faster.
  Float getRadius () const; 
  void setRadius (Float r);
  // Next four are redundant with AnyMouseXYMoveConfiguration.  Bummer.  Only
  // twice, and not much code, so I'm not making a subclass yet.
  int getX () const;
  int getY () const;
  void setX (int x);
  void setY (int y);
  SP<Configuration> copy () const  ;
  bool hasTheSameTypeAs (const Configuration *c) const;
};

#endif
