// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AnyMouseTrackballConfiguration_h__
#include "AnyMouseTrackballConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __PositiveFloatSlotValue_h__
#include "PositiveFloatSlotValue.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

namespace {
  String radiusName () {
    return "Virtual trackball radius (pixels)";
  }
}

AnyMouseTrackballConfiguration::AnyMouseTrackballConfiguration ()
{
  initializeSlot (radiusName (), NEW (PositiveFloatSlotValue (200)));
}

Float AnyMouseTrackballConfiguration::getRadius () const {
  return PositiveFloatSlotValue::getSlot (this, radiusName ());
}

void AnyMouseTrackballConfiguration::setRadius (Float r) {
  PositiveFloatSlotValue::setSlot (this, radiusName(), r);
}

int AnyMouseTrackballConfiguration::getX () const {
  return m_x;
}

int AnyMouseTrackballConfiguration::getY () const {
  return m_y;
}

void AnyMouseTrackballConfiguration::setX (int x) {
  m_x = x;
}

void AnyMouseTrackballConfiguration::setY (int y) {
  m_y = y;
}

SP<Configuration> AnyMouseTrackballConfiguration::copy () const {
  return NEW (AnyMouseTrackballConfiguration (*this));
}
  
bool AnyMouseTrackballConfiguration::hasTheSameTypeAs
(const Configuration *c) const
{
  return 0 != dynamic_cast <const AnyMouseTrackballConfiguration *> (c);
}
